/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GMGGBGAMMATABLE_H
#define GMGGBGAMMATABLE_H
#include "QObject"
typedef struct {
    unsigned char	 R;
     unsigned char	 G;
     unsigned char	 B;
} colorRGB8;

typedef struct {
    double	 L;
    double	 a;
    double	 b;
} colorLab;

typedef struct {
    double	 Y;
    double	 x;
    double	 y;
} colorYxy;

typedef struct {
    double	 X;
    double	 Y;
    double	 Z;
} colorXYZ;

typedef struct {
    double	 R;
    double	 G;
    double	 B;
} ColorRGB;

typedef struct {
    double	 U;
    double	 V;
    double	 W;
} colorUVW;

static const ColorRGB blackbodyDataD65modified[] = {
    { 1.0000, 0.0425, 0.0000 }, /* 1000K */
    { 1.0000, 0.0668, 0.0000 }, /* 1100K */
    { 1.0000, 0.0911, 0.0000 }, /* 1200K */
    { 1.0000, 0.1149, 0.0000 }, /* ... */
    { 1.0000, 0.1380, 0.0000 },
    { 1.0000, 0.1604, 0.0000 },
    { 1.0000, 0.1819, 0.0000 },
    { 1.0000, 0.2024, 0.0000 },
    { 1.0000, 0.2220, 0.0000 },
    { 1.0000, 0.2406, 0.0000 },
    { 1.0000, 0.2630, 0.0062 },/* 2000K */
    { 1.0000, 0.2868, 0.0155 },
    { 1.0000, 0.3102, 0.0261 },
    { 1.0000, 0.3334, 0.0379 },
    { 1.0000, 0.3562, 0.0508 },
    { 1.0000, 0.3787, 0.0650 },
    { 1.0000, 0.4008, 0.0802 },
    { 1.0000, 0.4227, 0.0964 },
    { 1.0000, 0.4442, 0.1136 },
    { 1.0000, 0.4652, 0.1316 },
    { 1.0000, 0.4859, 0.1505 },/* 3000K */
    { 1.0000, 0.5062, 0.1702 },
    { 1.0000, 0.5262, 0.1907 },
    { 1.0000, 0.5458, 0.2118 },
    { 1.0000, 0.5650, 0.2335 },
    { 1.0000, 0.5839, 0.2558 },
    { 1.0000, 0.6023, 0.2786 },
    { 1.0000, 0.6204, 0.3018 },
    { 1.0000, 0.6382, 0.3255 },
    { 1.0000, 0.6557, 0.3495 },
    { 1.0000, 0.6727, 0.3739 },/* 4000K */
    { 1.0000, 0.6894, 0.3986 },
    { 1.0000, 0.7058, 0.4234 },
    { 1.0000, 0.7218, 0.4485 },
    { 1.0000, 0.7375, 0.4738 },
    { 1.0000, 0.7529, 0.4992 },
    { 1.0000, 0.7679, 0.5247 },
    { 1.0000, 0.7826, 0.5503 },
    { 1.0000, 0.7970, 0.5760 },
    { 1.0000, 0.8111, 0.6016 },
    { 1.0000, 0.8250, 0.6272 },/* 5000K */
    { 1.0000, 0.8384, 0.6529 },
    { 1.0000, 0.8517, 0.6785 },
    { 1.0000, 0.8647, 0.7040 },
    { 1.0000, 0.8773, 0.7294 },
    { 1.0000, 0.8897, 0.7548 },
    { 1.0000, 0.9019, 0.7801 },
    { 1.0000, 0.9137, 0.8051 },
    { 1.0000, 0.9254, 0.8301 },
    { 1.0000, 0.9367, 0.8550 },
    { 1.0000, 0.9478, 0.8795 },/* 6000K */
    { 1.0000, 0.9587, 0.9040 },
    { 1.0000, 0.9694, 0.9283 },
    { 1.0000, 0.9798, 0.9524 },
    { 1.0000, 0.9900, 0.9763 },
    { 1.0000, 1.0000, 1.0000 }, /* 6500K */
    { 0.9771, 0.9867, 1.0000 },
    { 0.9554, 0.9740, 1.0000 },
    { 0.9349, 0.9618, 1.0000 },
    { 0.9154, 0.9500, 1.0000 },
    { 0.8968, 0.9389, 1.0000 },
    { 0.8792, 0.9282, 1.0000 },
    { 0.8624, 0.9179, 1.0000 },
    { 0.8465, 0.9080, 1.0000 },
    { 0.8313, 0.8986, 1.0000 },
    { 0.8167, 0.8895, 1.0000 },
    { 0.8029, 0.8808, 1.0000 },
    { 0.7896, 0.8724, 1.0000 },
    { 0.7769, 0.8643, 1.0000 },
    { 0.7648, 0.8565, 1.0000 },
    { 0.7532, 0.8490, 1.0000 },
    { 0.7420, 0.8418, 1.0000 },
    { 0.7314, 0.8348, 1.0000 },
    { 0.7212, 0.8281, 1.0000 },
    { 0.7113, 0.8216, 1.0000 },
    { 0.7018, 0.8153, 1.0000 },
    { 0.6927, 0.8092, 1.0000 },
    { 0.6839, 0.8032, 1.0000 },
    { 0.6755, 0.7975, 1.0000 },
    { 0.6674, 0.7921, 1.0000 },
    { 0.6595, 0.7867, 1.0000 },
    { 0.6520, 0.7816, 1.0000 },
    { 0.6447, 0.7765, 1.0000 },
    { 0.6376, 0.7717, 1.0000 },
    { 0.6308, 0.7670, 1.0000 },
    { 0.6242, 0.7623, 1.0000 },
    { 0.6179, 0.7579, 1.0000 },
    { 0.6117, 0.7536, 1.0000 },
    { 0.6058, 0.7493, 1.0000 },
    { 0.6000, 0.7453, 1.0000 },
    { 0.5944, 0.7414, 1.0000 } /* 10000K */
};

/* source: https://github.com/jonls/redshift/blob/master/README-colorramp
 * use a Planckian curve below 5000K */
static const ColorRGB blackbodyDataD65plankian[] = {
    { 1.0000, 0.1817, 0.0000 }, /* 1000K */
    { 1.0000, 0.2550, 0.0000 }, /* 1100K */
    { 1.0000, 0.3094, 0.0000 }, /* 1200K */
    { 1.0000, 0.3536, 0.0000 }, /* ... */
    { 1.0000, 0.3909, 0.0000 },
    { 1.0000, 0.4232, 0.0000 },
    { 1.0000, 0.4516, 0.0000 },
    { 1.0000, 0.4768, 0.0000 },
    { 1.0000, 0.4992, 0.0000 },
    { 1.0000, 0.5194, 0.0000 },
    { 1.0000, 0.5436, 0.0868 },/* 2000K */
    { 1.0000, 0.5662, 0.1407 },
    { 1.0000, 0.5873, 0.1836 },
    { 1.0000, 0.6072, 0.2214 },
    { 1.0000, 0.6260, 0.2559 },
    { 1.0000, 0.6437, 0.2882 },
    { 1.0000, 0.6605, 0.3187 },
    { 1.0000, 0.6765, 0.3479 },
    { 1.0000, 0.6916, 0.3758 },
    { 1.0000, 0.7060, 0.4027 },
    { 1.0000, 0.7198, 0.4286 },/* 3000K */
    { 1.0000, 0.7329, 0.4537 },
    { 1.0000, 0.7454, 0.4779 },
    { 1.0000, 0.7574, 0.5015 },
    { 1.0000, 0.7689, 0.5243 },
    { 1.0000, 0.7799, 0.5464 },
    { 1.0000, 0.7904, 0.5679 },
    { 1.0000, 0.8005, 0.5888 },
    { 1.0000, 0.8102, 0.6092 },
    { 1.0000, 0.8196, 0.6289 },
    { 1.0000, 0.8285, 0.6482 },/* 4000K */
    { 1.0000, 0.8372, 0.6669 },
    { 1.0000, 0.8455, 0.6851 },
    { 1.0000, 0.8535, 0.7028 },
    { 1.0000, 0.8612, 0.7201 },
    { 1.0000, 0.8686, 0.7369 },
    { 1.0000, 0.8758, 0.7533 },
    { 1.0000, 0.8827, 0.7692 },
    { 1.0000, 0.8893, 0.7848 },
    { 1.0000, 0.8958, 0.7999 },
    { 1.0000, 0.9020, 0.8147 },/* 5000K */
    { 1.0000, 0.9096, 0.8284 },
    { 1.0000, 0.9171, 0.8419 },
    { 1.0000, 0.9244, 0.8552 },
    { 1.0000, 0.9316, 0.8684 },
    { 1.0000, 0.9385, 0.8813 },
    { 1.0000, 0.9454, 0.8940 },
    { 1.0000, 0.9520, 0.9066 },
    { 1.0000, 0.9585, 0.9189 },
    { 1.0000, 0.9649, 0.9311 },
    { 1.0000, 0.9711, 0.9431 },
    { 1.0000, 0.9771, 0.9548 },
    { 1.0000, 0.9831, 0.9664 },
    { 1.0000, 0.9888, 0.9778 },
    { 1.0000, 0.9945, 0.9890 },
    { 1.0000, 1.0000, 1.0000 }, /* 6500K */
    { 0.9895, 0.9935, 1.0000 },
    { 0.9794, 0.9872, 1.0000 },
    { 0.9698, 0.9812, 1.0000 },
    { 0.9605, 0.9754, 1.0000 },
    { 0.9516, 0.9698, 1.0000 },
    { 0.9430, 0.9644, 1.0000 },
    { 0.9348, 0.9592, 1.0000 },
    { 0.9269, 0.9542, 1.0000 },
    { 0.9193, 0.9494, 1.0000 },
    { 0.9119, 0.9447, 1.0000 },
    { 0.9049, 0.9402, 1.0000 },
    { 0.8981, 0.9358, 1.0000 },
    { 0.8915, 0.9316, 1.0000 },
    { 0.8852, 0.9275, 1.0000 },
    { 0.8791, 0.9236, 1.0000 },
    { 0.8732, 0.9197, 1.0000 },
    { 0.8674, 0.9160, 1.0000 },
    { 0.8619, 0.9125, 1.0000 },
    { 0.8566, 0.9090, 1.0000 },
    { 0.8514, 0.9056, 1.0000 },
    { 0.8464, 0.9023, 1.0000 },
    { 0.8415, 0.8991, 1.0000 },
    { 0.8368, 0.8960, 1.0000 },
    { 0.8323, 0.8930, 1.0000 },
    { 0.8278, 0.8901, 1.0000 },
    { 0.8235, 0.8873, 1.0000 },
    { 0.8194, 0.8845, 1.0000 },
    { 0.8153, 0.8818, 1.0000 },
    { 0.8114, 0.8792, 1.0000 },
    { 0.8075, 0.8767, 1.0000 },
    { 0.8038, 0.8742, 1.0000 },
    { 0.8002, 0.8718, 1.0000 },
    { 0.7967, 0.8694, 1.0000 },
    { 0.7932, 0.8671, 1.0000 },
    { 0.7898, 0.8649, 1.0000 } /* 10000K */
};
#endif // GMGGBGAMMATABLE_H
