% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_as.latex.table.R
\name{.as.latex.table}
\alias{.as.latex.table}
\title{Create LaTeX tables from data.frames and RLum objects}
\usage{
.as.latex.table(
  x,
  row.names = NULL,
  col.names = NULL,
  comments = TRUE,
  pos = "c",
  digits = 3,
  rm.zero = TRUE,
  select = NULL,
  split = NULL,
  tabular_only = FALSE,
  ...
)
}
\arguments{
\item{x}{\link{data.frame} or \code{RLum} object (\strong{required})}

\item{row.names}{currently unused}

\item{col.names}{currently unused}

\item{comments}{\link{logical} (\emph{with default}):
insert LaTeX comments}

\item{pos}{\link{character} (\emph{with default}): \code{character} of length one specifying the
alignment of each column, e.g., \code{pos = 'clr'} for a three column data frame and
center, left and right alignment}

\item{digits}{\link{numeric} (\emph{with default}): number of digits to be displayed (numeric fields)}

\item{rm.zero}{\link{logical} (\emph{with default}): remove columns containing
only zeros, however, this might not be wanted in all cases}

\item{select}{\link{character} (\emph{optional}): a \link{character} vector passed to \link{subset}}

\item{split}{\link{integer} (\emph{optional}): an \link{integer} specifying the number of individual tables
the \link{data.frame} is split into. Useful for wide tables. Currently unused.}

\item{tabular_only}{\link{logical} (\emph{with default}): if \code{TRUE} only the tabular but not the
table environment is returned. This gives a lot of additional flexibility at hand}

\item{...}{options: \code{verbose}}
}
\value{
Returns LaTeX code
}
\description{
This function takes a \link{data.frame} and returns a table in LaTeX code that
can be copied into any TeX document.
}
\section{Function version}{
 0.2.1
}

\examples{
 df <- data.frame(x = 1:10, y = letters[1:10])
.as.latex.table(df)
.as.latex.table(df, pos = "lr")
.as.latex.table(df, select = "y", pos = "r")

}
\author{
Christoph Burow, University of Cologne (Germany) \cr
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Burow, C., Kreutzer, S., 2025. .as.latex.table(): Create LaTeX tables from data.frames and RLum objects. Function version 0.2.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{internal}
