# *Percona XtraBackup* 8.0.29-22 (2022-07-19)

[Percona XtraBackup for MySQL Databases](https://www.percona.com/software/mysql-database/percona-xtrabackup) enables MySQL backups without blocking user queries. Percona XtraBackup is ideal for companies with large data sets and mission-critical applications that cannot tolerate long periods of downtime. Offered free as an open source solution, Percona XtraBackup drives down backup costs while providing unique features for MySQL backups.

## Release Highlights

*Percona XtraBackup* 8.0.29-22 adds new redo log types to support the changes in the `INSTANT` algorithm behavior. *MySQL* 8.0.29 extended the support for `ALGORITHM=INSTANT` to allow columns to be added to any position in a table and column drops. Older versions of *Percona XtraBackup* are incompatible with *MySQL* 8.0.29 because of this new functionality.

!!! note

    *MySQL* 8.0.29 extended the support of the `ALTER TABLE … DROP COLUMNS` statement to use `ALGORITHM=INSTANT`. These operations only modify the metadata in the data directory and do not affect the physical structure. The `ALGORITHM=INSTANT` is the default setting for supported `DDL` operations. Prior to *MySQL* 8.0.29, an `ALGORITHM=INSTANT` column could only be added as the last table column. As of *MySQL* 8.0.29, the column can be added to any table position. The ability to add or drop a column in any position increases the complexity of crash recovery since the redo log does not have the logical positions from the data dictionary. The redo log contains the physical order for the table.

    *Percona Server for MySQL* 8.0.29-21 contains fixes for these issues. *Percona XtraBackup* 8.0.29 can backup and restore tables that used the `INSTANT` algorithm in ADD/DROP in *Percona Server* for MySQL. However, *MySQL* 8.0.29, if the server contains tables modified by INSTANT ADD/DROP, is unsafe for backups at this time. *Percona XtraBackup* detects the tables modified by `INSTANT` ADD/DROP and generates an error. This error lists the affected tables and provides instructions to convert the modified tables to regular tables.

## Useful Links

* The [Percona XtraBackup installation instructions](https://www.percona.com/doc/percona-xtrabackup/8.0/installation.html)

* The [Percona XtraBackup downloads](https://www.percona.com/downloads/Percona-XtraBackup-LATEST/)

* The [Percona XtraBackup GitHub location](https://github.com/percona/percona-xtrabackup)

* To contribute to the documentation, review the [Documentation Contribution Guide](https://github.com/percona/percona-xtrabackup/blob/8.0/storage/innobase/xtrabackup/doc/source/contributing.md)
