/*
 * SPDX-FileCopyrightText: 2015~2025 CSSlayer <wengxt@gmail.com>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 */

#ifndef _FCITX_UTILS_KEYNAMETABLE_H_
#define _FCITX_UTILS_KEYNAMETABLE_H_


#include <cstdint>
#include <fcitx-utils/macros.h>

FCITX_C_DECL_BEGIN

static const char *keyNameList[] _FCITX_UNUSED_ =
{
"0",
"1",
"10ChannelsDown",
"10ChannelsUp",
"2",
"3",
"3270_AltCursor",
"3270_Attn",
"3270_BackTab",
"3270_ChangeScreen",
"3270_Copy",
"3270_CursorBlink",
"3270_CursorSelect",
"3270_DeleteWord",
"3270_Duplicate",
"3270_Enter",
"3270_EraseEOF",
"3270_EraseInput",
"3270_ExSelect",
"3270_FieldMark",
"3270_Ident",
"3270_Jump",
"3270_KeyClick",
"3270_Left2",
"3270_PA1",
"3270_PA2",
"3270_PA3",
"3270_Play",
"3270_PrintScreen",
"3270_Quit",
"3270_Record",
"3270_Reset",
"3270_Right2",
"3270_Rule",
"3270_Setup",
"3270_Test",
"3DMode",
"4",
"5",
"6",
"7",
"8",
"9",
"A",
"AE",
"ALSToggle",
"Aacute",
"Abelowdot",
"Abreve",
"Abreveacute",
"Abrevebelowdot",
"Abrevegrave",
"Abrevehook",
"Abrevetilde",
"AccessX_Enable",
"AccessX_Feedback_Enable",
"Accessibility",
"Acircumflex",
"Acircumflexacute",
"Acircumflexbelowdot",
"Acircumflexgrave",
"Acircumflexhook",
"Acircumflextilde",
"AddFavorite",
"Addressbook",
"Adiaeresis",
"Agrave",
"Ahook",
"Alt_L",
"Alt_R",
"Amacron",
"Aogonek",
"AppSelect",
"ApplicationLeft",
"ApplicationRight",
"Arabic_0",
"Arabic_1",
"Arabic_2",
"Arabic_3",
"Arabic_4",
"Arabic_5",
"Arabic_6",
"Arabic_7",
"Arabic_8",
"Arabic_9",
"Arabic_ain",
"Arabic_alef",
"Arabic_alefmaksura",
"Arabic_beh",
"Arabic_comma",
"Arabic_dad",
"Arabic_dal",
"Arabic_damma",
"Arabic_dammatan",
"Arabic_ddal",
"Arabic_farsi_yeh",
"Arabic_fatha",
"Arabic_fathatan",
"Arabic_feh",
"Arabic_fullstop",
"Arabic_gaf",
"Arabic_ghain",
"Arabic_ha",
"Arabic_hah",
"Arabic_hamza",
"Arabic_hamza_above",
"Arabic_hamza_below",
"Arabic_hamzaonalef",
"Arabic_hamzaonwaw",
"Arabic_hamzaonyeh",
"Arabic_hamzaunderalef",
"Arabic_heh",
"Arabic_heh_doachashmee",
"Arabic_heh_goal",
"Arabic_jeem",
"Arabic_jeh",
"Arabic_kaf",
"Arabic_kasra",
"Arabic_kasratan",
"Arabic_keheh",
"Arabic_khah",
"Arabic_lam",
"Arabic_madda_above",
"Arabic_maddaonalef",
"Arabic_meem",
"Arabic_noon",
"Arabic_noon_ghunna",
"Arabic_peh",
"Arabic_percent",
"Arabic_qaf",
"Arabic_question_mark",
"Arabic_ra",
"Arabic_rreh",
"Arabic_sad",
"Arabic_seen",
"Arabic_semicolon",
"Arabic_shadda",
"Arabic_sheen",
"Arabic_sukun",
"Arabic_superscript_alef",
"Arabic_switch",
"Arabic_tah",
"Arabic_tatweel",
"Arabic_tcheh",
"Arabic_teh",
"Arabic_tehmarbuta",
"Arabic_thal",
"Arabic_theh",
"Arabic_tteh",
"Arabic_veh",
"Arabic_waw",
"Arabic_yeh",
"Arabic_yeh_baree",
"Arabic_zah",
"Arabic_zain",
"Aring",
"Armenian_AT",
"Armenian_AYB",
"Armenian_BEN",
"Armenian_CHA",
"Armenian_DA",
"Armenian_DZA",
"Armenian_E",
"Armenian_FE",
"Armenian_GHAT",
"Armenian_GIM",
"Armenian_HI",
"Armenian_HO",
"Armenian_INI",
"Armenian_JE",
"Armenian_KE",
"Armenian_KEN",
"Armenian_KHE",
"Armenian_LYUN",
"Armenian_MEN",
"Armenian_NU",
"Armenian_O",
"Armenian_PE",
"Armenian_PYUR",
"Armenian_RA",
"Armenian_RE",
"Armenian_SE",
"Armenian_SHA",
"Armenian_TCHE",
"Armenian_TO",
"Armenian_TSA",
"Armenian_TSO",
"Armenian_TYUN",
"Armenian_VEV",
"Armenian_VO",
"Armenian_VYUN",
"Armenian_YECH",
"Armenian_ZA",
"Armenian_ZHE",
"Armenian_accent",
"Armenian_amanak",
"Armenian_apostrophe",
"Armenian_at",
"Armenian_ayb",
"Armenian_ben",
"Armenian_but",
"Armenian_cha",
"Armenian_da",
"Armenian_dza",
"Armenian_e",
"Armenian_exclam",
"Armenian_fe",
"Armenian_full_stop",
"Armenian_ghat",
"Armenian_gim",
"Armenian_hi",
"Armenian_ho",
"Armenian_hyphen",
"Armenian_ini",
"Armenian_je",
"Armenian_ke",
"Armenian_ken",
"Armenian_khe",
"Armenian_ligature_ew",
"Armenian_lyun",
"Armenian_men",
"Armenian_nu",
"Armenian_o",
"Armenian_paruyk",
"Armenian_pe",
"Armenian_pyur",
"Armenian_question",
"Armenian_ra",
"Armenian_re",
"Armenian_se",
"Armenian_separation_mark",
"Armenian_sha",
"Armenian_shesht",
"Armenian_tche",
"Armenian_to",
"Armenian_tsa",
"Armenian_tso",
"Armenian_tyun",
"Armenian_verjaket",
"Armenian_vev",
"Armenian_vo",
"Armenian_vyun",
"Armenian_yech",
"Armenian_yentamna",
"Armenian_za",
"Armenian_zhe",
"AspectRatio",
"Assistant",
"Atilde",
"AttendantOff",
"AttendantOn",
"AttendantToggle",
"AudibleBell_Enable",
"Audio",
"AudioBassBoost",
"AudioChannelMode",
"AudioCycleTrack",
"AudioDesc",
"AudioForward",
"AudioLowerVolume",
"AudioMedia",
"AudioMicMute",
"AudioMute",
"AudioNext",
"AudioPause",
"AudioPlay",
"AudioPreset",
"AudioPrev",
"AudioRaiseVolume",
"AudioRandomPlay",
"AudioRecord",
"AudioRepeat",
"AudioRewind",
"AudioStop",
"AutopilotEngageToggle",
"Away",
"B",
"Babovedot",
"Back",
"BackForward",
"BackSpace",
"BackTab",
"Battery",
"Begin",
"Blue",
"Bluetooth",
"Book",
"BounceKeys_Enable",
"Break",
"BrightnessAdjust",
"BrightnessAuto",
"BrightnessMax",
"BrightnessMin",
"Buttonconfig",
"Byelorussian_SHORTU",
"Byelorussian_shortu",
"C",
"CD",
"CH",
"C_H",
"C_h",
"Cabovedot",
"Cacute",
"Calculater",
"Calculator",
"Calendar",
"CameraAccessDisable",
"CameraAccessEnable",
"CameraAccessToggle",
"CameraDown",
"CameraFocus",
"CameraLeft",
"CameraRight",
"CameraUp",
"CameraZoomIn",
"CameraZoomOut",
"Cancel",
"Caps_Lock",
"Ccaron",
"Ccedilla",
"Ccircumflex",
"Ch",
"ChannelDown",
"ChannelUp",
"Clear",
"ClearGrab",
"ClearLine",
"ClearvuSonar",
"Close",
"Codeinput",
"ColonSign",
"Community",
"Compaq_Q",
"ContextMenu",
"ContrastAdjust",
"ControlPanel",
"Control_L",
"Control_R",
"Copy",
"CruzeiroSign",
"Cut",
"CycleAngle",
"Cyrillic_A",
"Cyrillic_BE",
"Cyrillic_CHE",
"Cyrillic_CHE_descender",
"Cyrillic_CHE_vertstroke",
"Cyrillic_DE",
"Cyrillic_DZHE",
"Cyrillic_E",
"Cyrillic_EF",
"Cyrillic_EL",
"Cyrillic_EM",
"Cyrillic_EN",
"Cyrillic_EN_descender",
"Cyrillic_ER",
"Cyrillic_ES",
"Cyrillic_GHE",
"Cyrillic_GHE_bar",
"Cyrillic_HA",
"Cyrillic_HARDSIGN",
"Cyrillic_HA_descender",
"Cyrillic_I",
"Cyrillic_IE",
"Cyrillic_IO",
"Cyrillic_I_macron",
"Cyrillic_JE",
"Cyrillic_KA",
"Cyrillic_KA_descender",
"Cyrillic_KA_vertstroke",
"Cyrillic_LJE",
"Cyrillic_NJE",
"Cyrillic_O",
"Cyrillic_O_bar",
"Cyrillic_PE",
"Cyrillic_SCHWA",
"Cyrillic_SHA",
"Cyrillic_SHCHA",
"Cyrillic_SHHA",
"Cyrillic_SHORTI",
"Cyrillic_SOFTSIGN",
"Cyrillic_TE",
"Cyrillic_TSE",
"Cyrillic_U",
"Cyrillic_U_macron",
"Cyrillic_U_straight",
"Cyrillic_U_straight_bar",
"Cyrillic_VE",
"Cyrillic_YA",
"Cyrillic_YERU",
"Cyrillic_YU",
"Cyrillic_ZE",
"Cyrillic_ZHE",
"Cyrillic_ZHE_descender",
"Cyrillic_a",
"Cyrillic_be",
"Cyrillic_che",
"Cyrillic_che_descender",
"Cyrillic_che_vertstroke",
"Cyrillic_de",
"Cyrillic_dzhe",
"Cyrillic_e",
"Cyrillic_ef",
"Cyrillic_el",
"Cyrillic_em",
"Cyrillic_en",
"Cyrillic_en_descender",
"Cyrillic_er",
"Cyrillic_es",
"Cyrillic_ghe",
"Cyrillic_ghe_bar",
"Cyrillic_ha",
"Cyrillic_ha_descender",
"Cyrillic_hardsign",
"Cyrillic_i",
"Cyrillic_i_macron",
"Cyrillic_ie",
"Cyrillic_io",
"Cyrillic_je",
"Cyrillic_ka",
"Cyrillic_ka_descender",
"Cyrillic_ka_vertstroke",
"Cyrillic_lje",
"Cyrillic_nje",
"Cyrillic_o",
"Cyrillic_o_bar",
"Cyrillic_pe",
"Cyrillic_schwa",
"Cyrillic_sha",
"Cyrillic_shcha",
"Cyrillic_shha",
"Cyrillic_shorti",
"Cyrillic_softsign",
"Cyrillic_te",
"Cyrillic_tse",
"Cyrillic_u",
"Cyrillic_u_macron",
"Cyrillic_u_straight",
"Cyrillic_u_straight_bar",
"Cyrillic_ve",
"Cyrillic_ya",
"Cyrillic_yeru",
"Cyrillic_yu",
"Cyrillic_ze",
"Cyrillic_zhe",
"Cyrillic_zhe_descender",
"D",
"DOS",
"DRemove",
"DVD",
"Dabovedot",
"Dacute_accent",
"Data",
"Database",
"Dcaron",
"Dcedilla_accent",
"Dcircumflex_accent",
"Ddiaeresis",
"Delete",
"DeleteChar",
"DeleteLine",
"Dgrave_accent",
"Dictate",
"Display",
"DisplayOff",
"DisplayToggle",
"DoNotDisturb",
"Documents",
"DongSign",
"Down",
"Dring_accent",
"Dstroke",
"Dtilde",
"DualRangeRadar",
"E",
"ENG",
"ETH",
"EZH",
"Eabovedot",
"Eacute",
"Ebelowdot",
"Ecaron",
"Ecircumflex",
"Ecircumflexacute",
"Ecircumflexbelowdot",
"Ecircumflexgrave",
"Ecircumflexhook",
"Ecircumflextilde",
"EcuSign",
"Ediaeresis",
"Editor",
"Egrave",
"Ehook",
"Eisu_Shift",
"Eisu_toggle",
"Eject",
"Emacron",
"EmojiPicker",
"End",
"Eogonek",
"Escape",
"Eth",
"Etilde",
"EuroSign",
"Excel",
"Execute",
"Exit",
"Explorer",
"Ext16bit_L",
"Ext16bit_R",
"F",
"F1",
"F10",
"F11",
"F12",
"F13",
"F14",
"F15",
"F16",
"F17",
"F18",
"F19",
"F2",
"F20",
"F21",
"F22",
"F23",
"F24",
"F25",
"F26",
"F27",
"F28",
"F29",
"F3",
"F30",
"F31",
"F32",
"F33",
"F34",
"F35",
"F4",
"F5",
"F6",
"F7",
"F8",
"F9",
"FFrancSign",
"Fabovedot",
"Farsi_0",
"Farsi_1",
"Farsi_2",
"Farsi_3",
"Farsi_4",
"Farsi_5",
"Farsi_6",
"Farsi_7",
"Farsi_8",
"Farsi_9",
"Farsi_yeh",
"FastReverse",
"Favorites",
"Finance",
"Find",
"First_Virtual_Screen",
"FishingChart",
"Fn",
"FnRightShift",
"Fn_1",
"Fn_2",
"Fn_B",
"Fn_D",
"Fn_E",
"Fn_Esc",
"Fn_F",
"Fn_F1",
"Fn_F10",
"Fn_F11",
"Fn_F12",
"Fn_F2",
"Fn_F3",
"Fn_F4",
"Fn_F5",
"Fn_F6",
"Fn_F7",
"Fn_F8",
"Fn_F9",
"Fn_S",
"Forward",
"FrameBack",
"FrameForward",
"FullScreen",
"G",
"Gabovedot",
"Game",
"Gbreve",
"Gcaron",
"Gcedilla",
"Gcircumflex",
"Georgian_an",
"Georgian_ban",
"Georgian_can",
"Georgian_char",
"Georgian_chin",
"Georgian_cil",
"Georgian_don",
"Georgian_en",
"Georgian_fi",
"Georgian_gan",
"Georgian_ghan",
"Georgian_hae",
"Georgian_har",
"Georgian_he",
"Georgian_hie",
"Georgian_hoe",
"Georgian_in",
"Georgian_jhan",
"Georgian_jil",
"Georgian_kan",
"Georgian_khar",
"Georgian_las",
"Georgian_man",
"Georgian_nar",
"Georgian_on",
"Georgian_par",
"Georgian_phar",
"Georgian_qar",
"Georgian_rae",
"Georgian_san",
"Georgian_shin",
"Georgian_tan",
"Georgian_tar",
"Georgian_un",
"Georgian_vin",
"Georgian_we",
"Georgian_xan",
"Georgian_zen",
"Georgian_zhar",
"Go",
"GoTo",
"GraphicsEditor",
"Greek_ALPHA",
"Greek_ALPHAaccent",
"Greek_BETA",
"Greek_CHI",
"Greek_DELTA",
"Greek_EPSILON",
"Greek_EPSILONaccent",
"Greek_ETA",
"Greek_ETAaccent",
"Greek_GAMMA",
"Greek_IOTA",
"Greek_IOTAaccent",
"Greek_IOTAdiaeresis",
"Greek_IOTAdieresis",
"Greek_KAPPA",
"Greek_LAMBDA",
"Greek_LAMDA",
"Greek_MU",
"Greek_NU",
"Greek_OMEGA",
"Greek_OMEGAaccent",
"Greek_OMICRON",
"Greek_OMICRONaccent",
"Greek_PHI",
"Greek_PI",
"Greek_PSI",
"Greek_RHO",
"Greek_SIGMA",
"Greek_TAU",
"Greek_THETA",
"Greek_UPSILON",
"Greek_UPSILONaccent",
"Greek_UPSILONdieresis",
"Greek_XI",
"Greek_ZETA",
"Greek_accentdieresis",
"Greek_alpha",
"Greek_alphaaccent",
"Greek_beta",
"Greek_chi",
"Greek_delta",
"Greek_epsilon",
"Greek_epsilonaccent",
"Greek_eta",
"Greek_etaaccent",
"Greek_finalsmallsigma",
"Greek_gamma",
"Greek_horizbar",
"Greek_iota",
"Greek_iotaaccent",
"Greek_iotaaccentdieresis",
"Greek_iotadieresis",
"Greek_kappa",
"Greek_lambda",
"Greek_lamda",
"Greek_mu",
"Greek_nu",
"Greek_omega",
"Greek_omegaaccent",
"Greek_omicron",
"Greek_omicronaccent",
"Greek_phi",
"Greek_pi",
"Greek_psi",
"Greek_rho",
"Greek_sigma",
"Greek_switch",
"Greek_tau",
"Greek_theta",
"Greek_upsilon",
"Greek_upsilonaccent",
"Greek_upsilonaccentdieresis",
"Greek_upsilondieresis",
"Greek_xi",
"Greek_zeta",
"Green",
"H",
"Hangul",
"Hangul_A",
"Hangul_AE",
"Hangul_AraeA",
"Hangul_AraeAE",
"Hangul_Banja",
"Hangul_Cieuc",
"Hangul_Codeinput",
"Hangul_Dikeud",
"Hangul_E",
"Hangul_EO",
"Hangul_EU",
"Hangul_End",
"Hangul_Hanja",
"Hangul_Hieuh",
"Hangul_I",
"Hangul_Ieung",
"Hangul_J_Cieuc",
"Hangul_J_Dikeud",
"Hangul_J_Hieuh",
"Hangul_J_Ieung",
"Hangul_J_Jieuj",
"Hangul_J_Khieuq",
"Hangul_J_Kiyeog",
"Hangul_J_KiyeogSios",
"Hangul_J_KkogjiDalrinIeung",
"Hangul_J_Mieum",
"Hangul_J_Nieun",
"Hangul_J_NieunHieuh",
"Hangul_J_NieunJieuj",
"Hangul_J_PanSios",
"Hangul_J_Phieuf",
"Hangul_J_Pieub",
"Hangul_J_PieubSios",
"Hangul_J_Rieul",
"Hangul_J_RieulHieuh",
"Hangul_J_RieulKiyeog",
"Hangul_J_RieulMieum",
"Hangul_J_RieulPhieuf",
"Hangul_J_RieulPieub",
"Hangul_J_RieulSios",
"Hangul_J_RieulTieut",
"Hangul_J_Sios",
"Hangul_J_SsangKiyeog",
"Hangul_J_SsangSios",
"Hangul_J_Tieut",
"Hangul_J_YeorinHieuh",
"Hangul_Jamo",
"Hangul_Jeonja",
"Hangul_Jieuj",
"Hangul_Khieuq",
"Hangul_Kiyeog",
"Hangul_KiyeogSios",
"Hangul_KkogjiDalrinIeung",
"Hangul_Mieum",
"Hangul_MultipleCandidate",
"Hangul_Nieun",
"Hangul_NieunHieuh",
"Hangul_NieunJieuj",
"Hangul_O",
"Hangul_OE",
"Hangul_PanSios",
"Hangul_Phieuf",
"Hangul_Pieub",
"Hangul_PieubSios",
"Hangul_PostHanja",
"Hangul_PreHanja",
"Hangul_PreviousCandidate",
"Hangul_Rieul",
"Hangul_RieulHieuh",
"Hangul_RieulKiyeog",
"Hangul_RieulMieum",
"Hangul_RieulPhieuf",
"Hangul_RieulPieub",
"Hangul_RieulSios",
"Hangul_RieulTieut",
"Hangul_RieulYeorinHieuh",
"Hangul_Romaja",
"Hangul_SingleCandidate",
"Hangul_Sios",
"Hangul_Special",
"Hangul_SsangDikeud",
"Hangul_SsangJieuj",
"Hangul_SsangKiyeog",
"Hangul_SsangPieub",
"Hangul_SsangSios",
"Hangul_Start",
"Hangul_SunkyeongeumMieum",
"Hangul_SunkyeongeumPhieuf",
"Hangul_SunkyeongeumPieub",
"Hangul_Tieut",
"Hangul_U",
"Hangul_WA",
"Hangul_WAE",
"Hangul_WE",
"Hangul_WEO",
"Hangul_WI",
"Hangul_YA",
"Hangul_YAE",
"Hangul_YE",
"Hangul_YEO",
"Hangul_YI",
"Hangul_YO",
"Hangul_YU",
"Hangul_YeorinHieuh",
"Hangul_switch",
"HangupPhone",
"Hankaku",
"Hcircumflex",
"Hebrew_switch",
"Help",
"Henkan",
"Henkan_Mode",
"Hibernate",
"Hiragana",
"Hiragana_Katakana",
"History",
"Home",
"HomePage",
"HotLinks",
"Hstroke",
"Hyper_L",
"Hyper_R",
"I",
"IO",
"ISO_Center_Object",
"ISO_Continuous_Underline",
"ISO_Discontinuous_Underline",
"ISO_Emphasize",
"ISO_Enter",
"ISO_Fast_Cursor_Down",
"ISO_Fast_Cursor_Left",
"ISO_Fast_Cursor_Right",
"ISO_Fast_Cursor_Up",
"ISO_First_Group",
"ISO_First_Group_Lock",
"ISO_Group_Latch",
"ISO_Group_Lock",
"ISO_Group_Shift",
"ISO_Last_Group",
"ISO_Last_Group_Lock",
"ISO_Left_Tab",
"ISO_Level2_Latch",
"ISO_Level3_Latch",
"ISO_Level3_Lock",
"ISO_Level3_Shift",
"ISO_Level5_Latch",
"ISO_Level5_Lock",
"ISO_Level5_Shift",
"ISO_Lock",
"ISO_Move_Line_Down",
"ISO_Move_Line_Up",
"ISO_Next_Group",
"ISO_Next_Group_Lock",
"ISO_Partial_Line_Down",
"ISO_Partial_Line_Up",
"ISO_Partial_Space_Left",
"ISO_Partial_Space_Right",
"ISO_Prev_Group",
"ISO_Prev_Group_Lock",
"ISO_Release_Both_Margins",
"ISO_Release_Margin_Left",
"ISO_Release_Margin_Right",
"ISO_Set_Margin_Left",
"ISO_Set_Margin_Right",
"Iabovedot",
"Iacute",
"Ibelowdot",
"Ibreve",
"Icircumflex",
"Idiaeresis",
"Igrave",
"Ihook",
"Imacron",
"Images",
"Info",
"Insert",
"InsertChar",
"InsertLine",
"Iogonek",
"Itilde",
"J",
"Jcircumflex",
"Journal",
"K",
"KP_0",
"KP_1",
"KP_2",
"KP_3",
"KP_4",
"KP_5",
"KP_6",
"KP_7",
"KP_8",
"KP_9",
"KP_Add",
"KP_BackTab",
"KP_Begin",
"KP_Decimal",
"KP_Delete",
"KP_Divide",
"KP_Down",
"KP_End",
"KP_Enter",
"KP_Equal",
"KP_F1",
"KP_F2",
"KP_F3",
"KP_F4",
"KP_Home",
"KP_Insert",
"KP_Left",
"KP_Multiply",
"KP_Next",
"KP_Page_Down",
"KP_Page_Up",
"KP_Prior",
"KP_Right",
"KP_Separator",
"KP_Space",
"KP_Subtract",
"KP_Tab",
"KP_Up",
"Kana_Lock",
"Kana_Shift",
"Kanji",
"Kanji_Bangou",
"Katakana",
"KbdBrightnessDown",
"KbdBrightnessUp",
"KbdInputAssistAccept",
"KbdInputAssistCancel",
"KbdInputAssistNext",
"KbdInputAssistNextgroup",
"KbdInputAssistPrev",
"KbdInputAssistPrevgroup",
"KbdLcdMenu1",
"KbdLcdMenu2",
"KbdLcdMenu3",
"KbdLcdMenu4",
"KbdLcdMenu5",
"KbdLightOnOff",
"Kcedilla",
"Keyboard",
"Korean_Won",
"L",
"L1",
"L10",
"L2",
"L3",
"L4",
"L5",
"L6",
"L7",
"L8",
"L9",
"Lacute",
"Last_Virtual_Screen",
"Launch0",
"Launch1",
"Launch2",
"Launch3",
"Launch4",
"Launch5",
"Launch6",
"Launch7",
"Launch8",
"Launch9",
"LaunchA",
"LaunchB",
"LaunchC",
"LaunchD",
"LaunchE",
"LaunchF",
"Lbelowdot",
"Lcaron",
"Lcedilla",
"Left",
"LeftDown",
"LeftUp",
"LightBulb",
"LightsToggle",
"Linefeed",
"LinkPhone",
"LiraSign",
"LogGrabInfo",
"LogOff",
"LogWindowTree",
"Lstroke",
"M",
"Mabovedot",
"Macedonia_DSE",
"Macedonia_GJE",
"Macedonia_KJE",
"Macedonia_dse",
"Macedonia_gje",
"Macedonia_kje",
"Macro1",
"Macro10",
"Macro11",
"Macro12",
"Macro13",
"Macro14",
"Macro15",
"Macro16",
"Macro17",
"Macro18",
"Macro19",
"Macro2",
"Macro20",
"Macro21",
"Macro22",
"Macro23",
"Macro24",
"Macro25",
"Macro26",
"Macro27",
"Macro28",
"Macro29",
"Macro3",
"Macro30",
"Macro4",
"Macro5",
"Macro6",
"Macro7",
"Macro8",
"Macro9",
"MacroPreset1",
"MacroPreset2",
"MacroPreset3",
"MacroPresetCycle",
"MacroRecordStart",
"MacroRecordStop",
"Mae_Koho",
"Mail",
"MailForward",
"MarkWaypoint",
"Market",
"Massyo",
"MediaBreak",
"MediaLanguageMenu",
"MediaPlayPause",
"MediaPlaySlow",
"MediaPlayer",
"MediaRepeat",
"MediaSelectAuxiliary",
"MediaSelectCD",
"MediaSelectCable",
"MediaSelectDVD",
"MediaSelectHome",
"MediaSelectPC",
"MediaSelectProgramGuide",
"MediaSelectRadio",
"MediaSelectSatellite",
"MediaSelectTV",
"MediaSelectTape",
"MediaSelectTeletext",
"MediaSelectTuner",
"MediaSelectVCR",
"MediaSelectVCRPlus",
"MediaTitleMenu",
"MediaTopMenu",
"Meeting",
"Memo",
"Menu",
"MenuKB",
"MenuPB",
"Messenger",
"Meta_L",
"Meta_R",
"MillSign",
"ModeLock",
"Mode_switch",
"MonBrightnessAuto",
"MonBrightnessCycle",
"MonBrightnessDown",
"MonBrightnessUp",
"MouseKeys_Accel_Enable",
"MouseKeys_Enable",
"Muhenkan",
"Multi_key",
"MultipleCandidate",
"Music",
"MyComputer",
"MySites",
"N",
"Nacute",
"NairaSign",
"NavChart",
"NavInfo",
"Ncaron",
"Ncedilla",
"New",
"NewSheqelSign",
"News",
"Next",
"NextElement",
"NextFavorite",
"Next_VMode",
"Next_Virtual_Screen",
"None",
"NotificationCenter",
"Ntilde",
"Num_Lock",
"NumberEntryMode",
"Numeric0",
"Numeric1",
"Numeric11",
"Numeric12",
"Numeric2",
"Numeric3",
"Numeric4",
"Numeric5",
"Numeric6",
"Numeric7",
"Numeric8",
"Numeric9",
"NumericA",
"NumericB",
"NumericC",
"NumericD",
"NumericPound",
"NumericStar",
"O",
"OE",
"OK",
"Oacute",
"Obarred",
"Obelowdot",
"Ocaron",
"Ocircumflex",
"Ocircumflexacute",
"Ocircumflexbelowdot",
"Ocircumflexgrave",
"Ocircumflexhook",
"Ocircumflextilde",
"Odiaeresis",
"Odoubleacute",
"OfficeHome",
"Ograve",
"Ohook",
"Ohorn",
"Ohornacute",
"Ohornbelowdot",
"Ohorngrave",
"Ohornhook",
"Ohorntilde",
"Omacron",
"OnScreenKeyboard",
"Ooblique",
"Open",
"OpenURL",
"Option",
"Oslash",
"Otilde",
"Overlay1_Enable",
"Overlay2_Enable",
"P",
"Pabovedot",
"Page_Down",
"Page_Up",
"Paste",
"Pause",
"PauseRecord",
"PerformanceMode",
"PesetaSign",
"Phone",
"PickupPhone",
"Pictures",
"Pointer_Accelerate",
"Pointer_Button1",
"Pointer_Button2",
"Pointer_Button3",
"Pointer_Button4",
"Pointer_Button5",
"Pointer_Button_Dflt",
"Pointer_DblClick1",
"Pointer_DblClick2",
"Pointer_DblClick3",
"Pointer_DblClick4",
"Pointer_DblClick5",
"Pointer_DblClick_Dflt",
"Pointer_DfltBtnNext",
"Pointer_DfltBtnPrev",
"Pointer_Down",
"Pointer_DownLeft",
"Pointer_DownRight",
"Pointer_Drag1",
"Pointer_Drag2",
"Pointer_Drag3",
"Pointer_Drag4",
"Pointer_Drag5",
"Pointer_Drag_Dflt",
"Pointer_EnableKeys",
"Pointer_Left",
"Pointer_Right",
"Pointer_Up",
"Pointer_UpLeft",
"Pointer_UpRight",
"PowerDown",
"PowerOff",
"Presentation",
"Prev_VMode",
"Prev_Virtual_Screen",
"PreviousCandidate",
"PreviousElement",
"Print",
"Prior",
"PrivacyScreenToggle",
"Q",
"R",
"R1",
"R10",
"R11",
"R12",
"R13",
"R14",
"R15",
"R2",
"R3",
"R4",
"R5",
"R6",
"R7",
"R8",
"R9",
"RFKill",
"Racute",
"RadarOverlay",
"Rcaron",
"Rcedilla",
"Red",
"Redo",
"Refresh",
"RefreshRateToggle",
"Reload",
"RepeatKeys_Enable",
"Reply",
"Reset",
"Return",
"Right",
"RightDown",
"RightUp",
"RockerDown",
"RockerEnter",
"RockerUp",
"Romaji",
"RootMenu",
"RotateWindows",
"RotationKB",
"RotationLockToggle",
"RotationPB",
"RupeeSign",
"S",
"SCHWA",
"Sabovedot",
"Sacute",
"Save",
"Scaron",
"Scedilla",
"Scircumflex",
"ScreenSaver",
"Screensaver",
"ScrollClick",
"ScrollDown",
"ScrollUp",
"Scroll_Lock",
"Search",
"Select",
"SelectButton",
"SelectiveScreenshot",
"Send",
"Serbian_DJE",
"Serbian_DZE",
"Serbian_JE",
"Serbian_LJE",
"Serbian_NJE",
"Serbian_TSHE",
"Serbian_dje",
"Serbian_dze",
"Serbian_je",
"Serbian_lje",
"Serbian_nje",
"Serbian_tshe",
"Shift_L",
"Shift_Lock",
"Shift_R",
"Shop",
"SidevuSonar",
"SingleCandidate",
"SingleRangeRadar",
"Sinh_a",
"Sinh_aa",
"Sinh_aa2",
"Sinh_ae",
"Sinh_ae2",
"Sinh_aee",
"Sinh_aee2",
"Sinh_ai",
"Sinh_ai2",
"Sinh_al",
"Sinh_au",
"Sinh_au2",
"Sinh_ba",
"Sinh_bha",
"Sinh_ca",
"Sinh_cha",
"Sinh_dda",
"Sinh_ddha",
"Sinh_dha",
"Sinh_dhha",
"Sinh_e",
"Sinh_e2",
"Sinh_ee",
"Sinh_ee2",
"Sinh_fa",
"Sinh_ga",
"Sinh_gha",
"Sinh_h2",
"Sinh_ha",
"Sinh_i",
"Sinh_i2",
"Sinh_ii",
"Sinh_ii2",
"Sinh_ja",
"Sinh_jha",
"Sinh_jnya",
"Sinh_ka",
"Sinh_kha",
"Sinh_kunddaliya",
"Sinh_la",
"Sinh_lla",
"Sinh_lu",
"Sinh_lu2",
"Sinh_luu",
"Sinh_luu2",
"Sinh_ma",
"Sinh_mba",
"Sinh_na",
"Sinh_ndda",
"Sinh_ndha",
"Sinh_ng",
"Sinh_ng2",
"Sinh_nga",
"Sinh_nja",
"Sinh_nna",
"Sinh_nya",
"Sinh_o",
"Sinh_o2",
"Sinh_oo",
"Sinh_oo2",
"Sinh_pa",
"Sinh_pha",
"Sinh_ra",
"Sinh_ri",
"Sinh_rii",
"Sinh_ru2",
"Sinh_ruu2",
"Sinh_sa",
"Sinh_sha",
"Sinh_ssha",
"Sinh_tha",
"Sinh_thha",
"Sinh_tta",
"Sinh_ttha",
"Sinh_u",
"Sinh_u2",
"Sinh_uu",
"Sinh_uu2",
"Sinh_va",
"Sinh_ya",
"Sleep",
"SlowKeys_Enable",
"SlowReverse",
"Sos",
"Spell",
"SpellCheck",
"SplitScreen",
"Sport",
"Standby",
"Start",
"StickyKeys_Enable",
"Stop",
"StopRecord",
"Subtitle",
"SunAgain",
"SunAltGraph",
"SunAudioLowerVolume",
"SunAudioMute",
"SunAudioRaiseVolume",
"SunCompose",
"SunCopy",
"SunCut",
"SunF36",
"SunF37",
"SunFA_Acute",
"SunFA_Cedilla",
"SunFA_Circum",
"SunFA_Diaeresis",
"SunFA_Grave",
"SunFA_Tilde",
"SunFind",
"SunFront",
"SunOpen",
"SunPageDown",
"SunPageUp",
"SunPaste",
"SunPowerSwitch",
"SunPowerSwitchShift",
"SunPrint_Screen",
"SunProps",
"SunStop",
"SunSys_Req",
"SunUndo",
"SunVideoDegauss",
"SunVideoLowerBrightness",
"SunVideoRaiseBrightness",
"Super_L",
"Super_R",
"Support",
"Suspend",
"Switch_VT_1",
"Switch_VT_10",
"Switch_VT_11",
"Switch_VT_12",
"Switch_VT_2",
"Switch_VT_3",
"Switch_VT_4",
"Switch_VT_5",
"Switch_VT_6",
"Switch_VT_7",
"Switch_VT_8",
"Switch_VT_9",
"Sys_Req",
"System",
"T",
"THORN",
"Tab",
"Tabovedot",
"TaskPane",
"Taskmanager",
"Tcaron",
"Tcedilla",
"Terminal",
"Terminate_Server",
"Thai_baht",
"Thai_bobaimai",
"Thai_chochan",
"Thai_chochang",
"Thai_choching",
"Thai_chochoe",
"Thai_dochada",
"Thai_dodek",
"Thai_fofa",
"Thai_fofan",
"Thai_hohip",
"Thai_honokhuk",
"Thai_khokhai",
"Thai_khokhon",
"Thai_khokhuat",
"Thai_khokhwai",
"Thai_khorakhang",
"Thai_kokai",
"Thai_lakkhangyao",
"Thai_lekchet",
"Thai_lekha",
"Thai_lekhok",
"Thai_lekkao",
"Thai_leknung",
"Thai_lekpaet",
"Thai_leksam",
"Thai_leksi",
"Thai_leksong",
"Thai_leksun",
"Thai_lochula",
"Thai_loling",
"Thai_lu",
"Thai_maichattawa",
"Thai_maiek",
"Thai_maihanakat",
"Thai_maihanakat_maitho",
"Thai_maitaikhu",
"Thai_maitho",
"Thai_maitri",
"Thai_maiyamok",
"Thai_moma",
"Thai_ngongu",
"Thai_nikhahit",
"Thai_nonen",
"Thai_nonu",
"Thai_oang",
"Thai_paiyannoi",
"Thai_phinthu",
"Thai_phophan",
"Thai_phophung",
"Thai_phosamphao",
"Thai_popla",
"Thai_rorua",
"Thai_ru",
"Thai_saraa",
"Thai_saraaa",
"Thai_saraae",
"Thai_saraaimaimalai",
"Thai_saraaimaimuan",
"Thai_saraam",
"Thai_sarae",
"Thai_sarai",
"Thai_saraii",
"Thai_sarao",
"Thai_sarau",
"Thai_saraue",
"Thai_sarauee",
"Thai_sarauu",
"Thai_sorusi",
"Thai_sosala",
"Thai_soso",
"Thai_sosua",
"Thai_thanthakhat",
"Thai_thonangmontho",
"Thai_thophuthao",
"Thai_thothahan",
"Thai_thothan",
"Thai_thothong",
"Thai_thothung",
"Thai_topatak",
"Thai_totao",
"Thai_wowaen",
"Thai_yoyak",
"Thai_yoying",
"Thorn",
"Time",
"ToDoList",
"Tools",
"TopMenu",
"TouchpadOff",
"TouchpadOn",
"TouchpadToggle",
"Touroku",
"TraditionalSonar",
"Travel",
"Tslash",
"U",
"Uacute",
"Ubelowdot",
"Ubreve",
"Ucircumflex",
"Udiaeresis",
"Udoubleacute",
"Ugrave",
"Uhook",
"Uhorn",
"Uhornacute",
"Uhornbelowdot",
"Uhorngrave",
"Uhornhook",
"Uhorntilde",
"Ukrainian_GHE_WITH_UPTURN",
"Ukrainian_I",
"Ukrainian_IE",
"Ukrainian_YI",
"Ukrainian_ghe_with_upturn",
"Ukrainian_i",
"Ukrainian_ie",
"Ukrainian_yi",
"Ukranian_I",
"Ukranian_JE",
"Ukranian_YI",
"Ukranian_i",
"Ukranian_je",
"Ukranian_yi",
"Umacron",
"Undo",
"Ungrab",
"Unmute",
"Uogonek",
"Up",
"Uring",
"User",
"User1KB",
"User2KB",
"UserPB",
"Utilde",
"V",
"VOD",
"VendorHome",
"VendorLogo",
"Video",
"VideoPhone",
"View",
"VoiceCommand",
"Voicemail",
"VoidSymbol",
"W",
"WLAN",
"WPSButton",
"WWAN",
"WWW",
"Wacute",
"WakeUp",
"Wcircumflex",
"Wdiaeresis",
"WebCam",
"Wgrave",
"WheelButton",
"WindowClear",
"WonSign",
"Word",
"X",
"Xabovedot",
"Xfer",
"Y",
"Yacute",
"Ybelowdot",
"Ycircumflex",
"Ydiaeresis",
"Yellow",
"Ygrave",
"Yhook",
"Ytilde",
"Z",
"Zabovedot",
"Zacute",
"Zcaron",
"Zen_Koho",
"Zenkaku",
"Zenkaku_Hankaku",
"ZoomIn",
"ZoomOut",
"ZoomReset",
"Zstroke",
"a",
"aacute",
"abelowdot",
"abovedot",
"abreve",
"abreveacute",
"abrevebelowdot",
"abrevegrave",
"abrevehook",
"abrevetilde",
"acircumflex",
"acircumflexacute",
"acircumflexbelowdot",
"acircumflexgrave",
"acircumflexhook",
"acircumflextilde",
"acute",
"adiaeresis",
"ae",
"agrave",
"ahook",
"amacron",
"ampersand",
"aogonek",
"apostrophe",
"approxeq",
"approximate",
"aring",
"asciicircum",
"asciitilde",
"asterisk",
"at",
"atilde",
"b",
"babovedot",
"backslash",
"ballotcross",
"bar",
"because",
"blank",
"block",
"botintegral",
"botleftparens",
"botleftsqbracket",
"botleftsummation",
"botrightparens",
"botrightsqbracket",
"botrightsummation",
"bott",
"botvertsummationconnector",
"braceleft",
"braceright",
"bracketleft",
"bracketright",
"braille_blank",
"braille_dot_1",
"braille_dot_10",
"braille_dot_2",
"braille_dot_3",
"braille_dot_4",
"braille_dot_5",
"braille_dot_6",
"braille_dot_7",
"braille_dot_8",
"braille_dot_9",
"braille_dots_1",
"braille_dots_12",
"braille_dots_123",
"braille_dots_1234",
"braille_dots_12345",
"braille_dots_123456",
"braille_dots_1234567",
"braille_dots_12345678",
"braille_dots_1234568",
"braille_dots_123457",
"braille_dots_1234578",
"braille_dots_123458",
"braille_dots_12346",
"braille_dots_123467",
"braille_dots_1234678",
"braille_dots_123468",
"braille_dots_12347",
"braille_dots_123478",
"braille_dots_12348",
"braille_dots_1235",
"braille_dots_12356",
"braille_dots_123567",
"braille_dots_1235678",
"braille_dots_123568",
"braille_dots_12357",
"braille_dots_123578",
"braille_dots_12358",
"braille_dots_1236",
"braille_dots_12367",
"braille_dots_123678",
"braille_dots_12368",
"braille_dots_1237",
"braille_dots_12378",
"braille_dots_1238",
"braille_dots_124",
"braille_dots_1245",
"braille_dots_12456",
"braille_dots_124567",
"braille_dots_1245678",
"braille_dots_124568",
"braille_dots_12457",
"braille_dots_124578",
"braille_dots_12458",
"braille_dots_1246",
"braille_dots_12467",
"braille_dots_124678",
"braille_dots_12468",
"braille_dots_1247",
"braille_dots_12478",
"braille_dots_1248",
"braille_dots_125",
"braille_dots_1256",
"braille_dots_12567",
"braille_dots_125678",
"braille_dots_12568",
"braille_dots_1257",
"braille_dots_12578",
"braille_dots_1258",
"braille_dots_126",
"braille_dots_1267",
"braille_dots_12678",
"braille_dots_1268",
"braille_dots_127",
"braille_dots_1278",
"braille_dots_128",
"braille_dots_13",
"braille_dots_134",
"braille_dots_1345",
"braille_dots_13456",
"braille_dots_134567",
"braille_dots_1345678",
"braille_dots_134568",
"braille_dots_13457",
"braille_dots_134578",
"braille_dots_13458",
"braille_dots_1346",
"braille_dots_13467",
"braille_dots_134678",
"braille_dots_13468",
"braille_dots_1347",
"braille_dots_13478",
"braille_dots_1348",
"braille_dots_135",
"braille_dots_1356",
"braille_dots_13567",
"braille_dots_135678",
"braille_dots_13568",
"braille_dots_1357",
"braille_dots_13578",
"braille_dots_1358",
"braille_dots_136",
"braille_dots_1367",
"braille_dots_13678",
"braille_dots_1368",
"braille_dots_137",
"braille_dots_1378",
"braille_dots_138",
"braille_dots_14",
"braille_dots_145",
"braille_dots_1456",
"braille_dots_14567",
"braille_dots_145678",
"braille_dots_14568",
"braille_dots_1457",
"braille_dots_14578",
"braille_dots_1458",
"braille_dots_146",
"braille_dots_1467",
"braille_dots_14678",
"braille_dots_1468",
"braille_dots_147",
"braille_dots_1478",
"braille_dots_148",
"braille_dots_15",
"braille_dots_156",
"braille_dots_1567",
"braille_dots_15678",
"braille_dots_1568",
"braille_dots_157",
"braille_dots_1578",
"braille_dots_158",
"braille_dots_16",
"braille_dots_167",
"braille_dots_1678",
"braille_dots_168",
"braille_dots_17",
"braille_dots_178",
"braille_dots_18",
"braille_dots_2",
"braille_dots_23",
"braille_dots_234",
"braille_dots_2345",
"braille_dots_23456",
"braille_dots_234567",
"braille_dots_2345678",
"braille_dots_234568",
"braille_dots_23457",
"braille_dots_234578",
"braille_dots_23458",
"braille_dots_2346",
"braille_dots_23467",
"braille_dots_234678",
"braille_dots_23468",
"braille_dots_2347",
"braille_dots_23478",
"braille_dots_2348",
"braille_dots_235",
"braille_dots_2356",
"braille_dots_23567",
"braille_dots_235678",
"braille_dots_23568",
"braille_dots_2357",
"braille_dots_23578",
"braille_dots_2358",
"braille_dots_236",
"braille_dots_2367",
"braille_dots_23678",
"braille_dots_2368",
"braille_dots_237",
"braille_dots_2378",
"braille_dots_238",
"braille_dots_24",
"braille_dots_245",
"braille_dots_2456",
"braille_dots_24567",
"braille_dots_245678",
"braille_dots_24568",
"braille_dots_2457",
"braille_dots_24578",
"braille_dots_2458",
"braille_dots_246",
"braille_dots_2467",
"braille_dots_24678",
"braille_dots_2468",
"braille_dots_247",
"braille_dots_2478",
"braille_dots_248",
"braille_dots_25",
"braille_dots_256",
"braille_dots_2567",
"braille_dots_25678",
"braille_dots_2568",
"braille_dots_257",
"braille_dots_2578",
"braille_dots_258",
"braille_dots_26",
"braille_dots_267",
"braille_dots_2678",
"braille_dots_268",
"braille_dots_27",
"braille_dots_278",
"braille_dots_28",
"braille_dots_3",
"braille_dots_34",
"braille_dots_345",
"braille_dots_3456",
"braille_dots_34567",
"braille_dots_345678",
"braille_dots_34568",
"braille_dots_3457",
"braille_dots_34578",
"braille_dots_3458",
"braille_dots_346",
"braille_dots_3467",
"braille_dots_34678",
"braille_dots_3468",
"braille_dots_347",
"braille_dots_3478",
"braille_dots_348",
"braille_dots_35",
"braille_dots_356",
"braille_dots_3567",
"braille_dots_35678",
"braille_dots_3568",
"braille_dots_357",
"braille_dots_3578",
"braille_dots_358",
"braille_dots_36",
"braille_dots_367",
"braille_dots_3678",
"braille_dots_368",
"braille_dots_37",
"braille_dots_378",
"braille_dots_38",
"braille_dots_4",
"braille_dots_45",
"braille_dots_456",
"braille_dots_4567",
"braille_dots_45678",
"braille_dots_4568",
"braille_dots_457",
"braille_dots_4578",
"braille_dots_458",
"braille_dots_46",
"braille_dots_467",
"braille_dots_4678",
"braille_dots_468",
"braille_dots_47",
"braille_dots_478",
"braille_dots_48",
"braille_dots_5",
"braille_dots_56",
"braille_dots_567",
"braille_dots_5678",
"braille_dots_568",
"braille_dots_57",
"braille_dots_578",
"braille_dots_58",
"braille_dots_6",
"braille_dots_67",
"braille_dots_678",
"braille_dots_68",
"braille_dots_7",
"braille_dots_78",
"braille_dots_8",
"breve",
"brokenbar",
"c",
"c_h",
"cabovedot",
"cacute",
"careof",
"caret",
"caron",
"ccaron",
"ccedilla",
"ccircumflex",
"cedilla",
"cent",
"ch",
"checkerboard",
"checkmark",
"circle",
"club",
"colon",
"combining_acute",
"combining_belowdot",
"combining_grave",
"combining_hook",
"combining_tilde",
"comma",
"containsas",
"copyright",
"cr",
"crossinglines",
"cuberoot",
"currency",
"cursor",
"d",
"dabovedot",
"dagger",
"dcaron",
"dead_A",
"dead_E",
"dead_I",
"dead_O",
"dead_SCHWA",
"dead_U",
"dead_a",
"dead_abovecomma",
"dead_abovedot",
"dead_abovereversedcomma",
"dead_abovering",
"dead_aboveverticalline",
"dead_acute",
"dead_belowbreve",
"dead_belowcircumflex",
"dead_belowcomma",
"dead_belowdiaeresis",
"dead_belowdot",
"dead_belowmacron",
"dead_belowring",
"dead_belowtilde",
"dead_belowverticalline",
"dead_breve",
"dead_capital_schwa",
"dead_caron",
"dead_cedilla",
"dead_circumflex",
"dead_currency",
"dead_dasia",
"dead_diaeresis",
"dead_doubleacute",
"dead_doublegrave",
"dead_e",
"dead_grave",
"dead_greek",
"dead_hamza",
"dead_hook",
"dead_horn",
"dead_i",
"dead_invertedbreve",
"dead_iota",
"dead_longsolidusoverlay",
"dead_lowline",
"dead_macron",
"dead_o",
"dead_ogonek",
"dead_perispomeni",
"dead_psili",
"dead_schwa",
"dead_semivoiced_sound",
"dead_small_schwa",
"dead_stroke",
"dead_tilde",
"dead_u",
"dead_voiced_sound",
"decimalpoint",
"degree",
"diaeresis",
"diamond",
"digitspace",
"dintegral",
"division",
"dollar",
"doubbaselinedot",
"doubleacute",
"doubledagger",
"doublelowquotemark",
"downarrow",
"downcaret",
"downshoe",
"downstile",
"downtack",
"dstroke",
"e",
"eabovedot",
"eacute",
"ebelowdot",
"ecaron",
"ecircumflex",
"ecircumflexacute",
"ecircumflexbelowdot",
"ecircumflexgrave",
"ecircumflexhook",
"ecircumflextilde",
"ediaeresis",
"egrave",
"ehook",
"eightsubscript",
"eightsuperior",
"elementof",
"ellipsis",
"em3space",
"em4space",
"emacron",
"emdash",
"emfilledcircle",
"emfilledrect",
"emopencircle",
"emopenrectangle",
"emptyset",
"emspace",
"endash",
"enfilledcircbullet",
"enfilledsqbullet",
"eng",
"enopencircbullet",
"enopensquarebullet",
"enspace",
"eogonek",
"equal",
"eth",
"etilde",
"exclam",
"exclamdown",
"ezh",
"f",
"fabovedot",
"femalesymbol",
"ff",
"figdash",
"filledlefttribullet",
"filledrectbullet",
"filledrighttribullet",
"filledtribulletdown",
"filledtribulletup",
"fiveeighths",
"fivesixths",
"fivesubscript",
"fivesuperior",
"fourfifths",
"foursubscript",
"foursuperior",
"fourthroot",
"function",
"g",
"gabovedot",
"gbreve",
"gcaron",
"gcedilla",
"gcircumflex",
"grave",
"greater",
"greaterthanequal",
"guilder",
"guillemetleft",
"guillemetright",
"guillemotleft",
"guillemotright",
"h",
"hairspace",
"hcircumflex",
"heart",
"hebrew_aleph",
"hebrew_ayin",
"hebrew_bet",
"hebrew_beth",
"hebrew_chet",
"hebrew_dalet",
"hebrew_daleth",
"hebrew_doublelowline",
"hebrew_finalkaph",
"hebrew_finalmem",
"hebrew_finalnun",
"hebrew_finalpe",
"hebrew_finalzade",
"hebrew_finalzadi",
"hebrew_gimel",
"hebrew_gimmel",
"hebrew_he",
"hebrew_het",
"hebrew_kaph",
"hebrew_kuf",
"hebrew_lamed",
"hebrew_mem",
"hebrew_nun",
"hebrew_pe",
"hebrew_qoph",
"hebrew_resh",
"hebrew_samech",
"hebrew_samekh",
"hebrew_shin",
"hebrew_taf",
"hebrew_taw",
"hebrew_tet",
"hebrew_teth",
"hebrew_waw",
"hebrew_yod",
"hebrew_zade",
"hebrew_zadi",
"hebrew_zain",
"hebrew_zayin",
"hexagram",
"horizconnector",
"horizlinescan1",
"horizlinescan3",
"horizlinescan5",
"horizlinescan7",
"horizlinescan9",
"hpBackTab",
"hpClearLine",
"hpDeleteChar",
"hpDeleteLine",
"hpIO",
"hpInsertChar",
"hpInsertLine",
"hpKP_BackTab",
"hpModelock1",
"hpModelock2",
"hpReset",
"hpSystem",
"hpUser",
"hpYdiaeresis",
"hpblock",
"hpguilder",
"hplira",
"hplongminus",
"hpmute_acute",
"hpmute_asciicircum",
"hpmute_asciitilde",
"hpmute_diaeresis",
"hpmute_grave",
"hstroke",
"ht",
"hyphen",
"i",
"iTouch",
"iacute",
"ibelowdot",
"ibreve",
"icircumflex",
"identical",
"idiaeresis",
"idotless",
"ifonlyif",
"igrave",
"ihook",
"imacron",
"implies",
"includedin",
"includes",
"infinity",
"integral",
"intersection",
"iogonek",
"itilde",
"j",
"jcircumflex",
"jot",
"k",
"kana_A",
"kana_CHI",
"kana_E",
"kana_FU",
"kana_HA",
"kana_HE",
"kana_HI",
"kana_HO",
"kana_HU",
"kana_I",
"kana_KA",
"kana_KE",
"kana_KI",
"kana_KO",
"kana_KU",
"kana_MA",
"kana_ME",
"kana_MI",
"kana_MO",
"kana_MU",
"kana_N",
"kana_NA",
"kana_NE",
"kana_NI",
"kana_NO",
"kana_NU",
"kana_O",
"kana_RA",
"kana_RE",
"kana_RI",
"kana_RO",
"kana_RU",
"kana_SA",
"kana_SE",
"kana_SHI",
"kana_SO",
"kana_SU",
"kana_TA",
"kana_TE",
"kana_TI",
"kana_TO",
"kana_TSU",
"kana_TU",
"kana_U",
"kana_WA",
"kana_WO",
"kana_YA",
"kana_YO",
"kana_YU",
"kana_a",
"kana_closingbracket",
"kana_comma",
"kana_conjunctive",
"kana_e",
"kana_fullstop",
"kana_i",
"kana_middledot",
"kana_o",
"kana_openingbracket",
"kana_switch",
"kana_tsu",
"kana_tu",
"kana_u",
"kana_ya",
"kana_yo",
"kana_yu",
"kappa",
"kcedilla",
"kra",
"l",
"lacute",
"latincross",
"lbelowdot",
"lcaron",
"lcedilla",
"leftanglebracket",
"leftarrow",
"leftcaret",
"leftdoublequotemark",
"leftmiddlecurlybrace",
"leftopentriangle",
"leftpointer",
"leftradical",
"leftshoe",
"leftsinglequotemark",
"leftt",
"lefttack",
"less",
"lessthanequal",
"lf",
"lira",
"logicaland",
"logicalor",
"longminus",
"lowleftcorner",
"lowrightcorner",
"lstroke",
"m",
"mabovedot",
"macron",
"malesymbol",
"maltesecross",
"marker",
"masculine",
"minus",
"minutes",
"mu",
"multiply",
"musicalflat",
"musicalsharp",
"mute_acute",
"mute_asciicircum",
"mute_asciitilde",
"mute_diaeresis",
"mute_grave",
"n",
"nabla",
"nacute",
"ncaron",
"ncedilla",
"ninesubscript",
"ninesuperior",
"nl",
"nobreakspace",
"notapproxeq",
"notelementof",
"notequal",
"notidentical",
"notsign",
"ntilde",
"numbersign",
"numerosign",
"o",
"oacute",
"obarred",
"obelowdot",
"ocaron",
"ocircumflex",
"ocircumflexacute",
"ocircumflexbelowdot",
"ocircumflexgrave",
"ocircumflexhook",
"ocircumflextilde",
"odiaeresis",
"odoubleacute",
"oe",
"ogonek",
"ograve",
"ohook",
"ohorn",
"ohornacute",
"ohornbelowdot",
"ohorngrave",
"ohornhook",
"ohorntilde",
"omacron",
"oneeighth",
"onefifth",
"onehalf",
"onequarter",
"onesixth",
"onesubscript",
"onesuperior",
"onethird",
"ooblique",
"openrectbullet",
"openstar",
"opentribulletdown",
"opentribulletup",
"ordfeminine",
"ordmasculine",
"osfActivate",
"osfAddMode",
"osfBackSpace",
"osfBackTab",
"osfBeginData",
"osfBeginLine",
"osfCancel",
"osfClear",
"osfCopy",
"osfCut",
"osfDelete",
"osfDeselectAll",
"osfDown",
"osfEndData",
"osfEndLine",
"osfEscape",
"osfExtend",
"osfHelp",
"osfInsert",
"osfLeft",
"osfMenu",
"osfMenuBar",
"osfNextField",
"osfNextMenu",
"osfPageDown",
"osfPageLeft",
"osfPageRight",
"osfPageUp",
"osfPaste",
"osfPrevField",
"osfPrevMenu",
"osfPrimaryPaste",
"osfQuickPaste",
"osfReselect",
"osfRestore",
"osfRight",
"osfSelect",
"osfSelectAll",
"osfUndo",
"osfUp",
"oslash",
"otilde",
"overbar",
"overline",
"p",
"pabovedot",
"paragraph",
"parenleft",
"parenright",
"partdifferential",
"partialderivative",
"percent",
"period",
"periodcentered",
"permille",
"phonographcopyright",
"plus",
"plusminus",
"prescription",
"prolongedsound",
"punctspace",
"q",
"quad",
"question",
"questiondown",
"quotedbl",
"quoteleft",
"quoteright",
"r",
"racute",
"radical",
"rcaron",
"rcedilla",
"registered",
"rightanglebracket",
"rightarrow",
"rightcaret",
"rightdoublequotemark",
"rightmiddlecurlybrace",
"rightmiddlesummation",
"rightopentriangle",
"rightpointer",
"rightshoe",
"rightsinglequotemark",
"rightt",
"righttack",
"s",
"sabovedot",
"sacute",
"scaron",
"scedilla",
"schwa",
"scircumflex",
"script_switch",
"seconds",
"section",
"semicolon",
"semivoicedsound",
"seveneighths",
"sevensubscript",
"sevensuperior",
"signaturemark",
"signifblank",
"similarequal",
"singlelowquotemark",
"sixsubscript",
"sixsuperior",
"slash",
"soliddiamond",
"space",
"squareroot",
"ssharp",
"sterling",
"stricteq",
"t",
"tabovedot",
"tcaron",
"tcedilla",
"telephone",
"telephonerecorder",
"therefore",
"thinspace",
"thorn",
"threeeighths",
"threefifths",
"threequarters",
"threesubscript",
"threesuperior",
"tintegral",
"topintegral",
"topleftparens",
"topleftradical",
"topleftsqbracket",
"topleftsummation",
"toprightparens",
"toprightsqbracket",
"toprightsummation",
"topt",
"topvertsummationconnector",
"trademark",
"trademarkincircle",
"tslash",
"twofifths",
"twosubscript",
"twosuperior",
"twothirds",
"u",
"uacute",
"ubelowdot",
"ubreve",
"ucircumflex",
"udiaeresis",
"udoubleacute",
"ugrave",
"uhook",
"uhorn",
"uhornacute",
"uhornbelowdot",
"uhorngrave",
"uhornhook",
"uhorntilde",
"umacron",
"underbar",
"underscore",
"union",
"uogonek",
"uparrow",
"upcaret",
"upleftcorner",
"uprightcorner",
"upshoe",
"upstile",
"uptack",
"uring",
"utilde",
"v",
"variation",
"vertbar",
"vertconnector",
"voicedsound",
"vt",
"w",
"wacute",
"wcircumflex",
"wdiaeresis",
"wgrave",
"x",
"xabovedot",
"y",
"yacute",
"ybelowdot",
"ycircumflex",
"ydiaeresis",
"yen",
"ygrave",
"yhook",
"ytilde",
"z",
"zabovedot",
"zacute",
"zcaron",
"zerosubscript",
"zerosuperior",
"zstroke",
};

static const uint32_t keyValueByNameOffset[] _FCITX_UNUSED_ =
{
0x30,
0x31,
0x100811b9,
0x100811b8,
0x32,
0x33,
0xfd10,
0xfd0e,
0xfd05,
0xfd19,
0xfd15,
0xfd0f,
0xfd1c,
0xfd1a,
0xfd01,
0xfd1e,
0xfd06,
0xfd07,
0xfd1b,
0xfd02,
0xfd13,
0xfd12,
0xfd11,
0xfd04,
0xfd0a,
0xfd0b,
0xfd0c,
0xfd16,
0xfd1d,
0xfd09,
0xfd18,
0xfd08,
0xfd03,
0xfd14,
0xfd17,
0xfd0d,
0x1008126f,
0x34,
0x35,
0x36,
0x37,
0x38,
0x39,
0x41,
0xc6,
0x10081230,
0xc1,
0x1001ea0,
0x1c3,
0x1001eae,
0x1001eb6,
0x1001eb0,
0x1001eb2,
0x1001eb4,
0xfe70,
0xfe71,
0x1008124e,
0xc2,
0x1001ea4,
0x1001eac,
0x1001ea6,
0x1001ea8,
0x1001eaa,
0x1008ff39,
0x100811ad,
0xc4,
0xc0,
0x1001ea2,
0xffe9,
0xffea,
0x3c0,
0x1a1,
0x10081244,
0x1008ff50,
0x1008ff51,
0x1000660,
0x1000661,
0x1000662,
0x1000663,
0x1000664,
0x1000665,
0x1000666,
0x1000667,
0x1000668,
0x1000669,
0x5d9,
0x5c7,
0x5e9,
0x5c8,
0x5ac,
0x5d6,
0x5cf,
0x5ef,
0x5ec,
0x1000688,
0x10006cc,
0x5ee,
0x5eb,
0x5e1,
0x10006d4,
0x10006af,
0x5da,
0x5e7,
0x5cd,
0x5c1,
0x1000654,
0x1000655,
0x5c3,
0x5c4,
0x5c6,
0x5c5,
0x5e7,
0x10006be,
0x10006c1,
0x5cc,
0x1000698,
0x5e3,
0x5f0,
0x5ed,
0x10006a9,
0x5ce,
0x5e4,
0x1000653,
0x5c2,
0x5e5,
0x5e6,
0x10006ba,
0x100067e,
0x100066a,
0x5e2,
0x5bf,
0x5d1,
0x1000691,
0x5d5,
0x5d3,
0x5bb,
0x5f1,
0x5d4,
0x5f2,
0x1000670,
0xff7e,
0x5d7,
0x5e0,
0x1000686,
0x5ca,
0x5c9,
0x5d0,
0x5cb,
0x1000679,
0x10006a4,
0x5e8,
0x5ea,
0x10006d2,
0x5d8,
0x5d2,
0xc5,
0x1000538,
0x1000531,
0x1000532,
0x1000549,
0x1000534,
0x1000541,
0x1000537,
0x1000556,
0x1000542,
0x1000533,
0x1000545,
0x1000540,
0x100053b,
0x100054b,
0x1000554,
0x100053f,
0x100053d,
0x100053c,
0x1000544,
0x1000546,
0x1000555,
0x100054a,
0x1000553,
0x100054c,
0x1000550,
0x100054d,
0x1000547,
0x1000543,
0x1000539,
0x100053e,
0x1000551,
0x100054f,
0x100054e,
0x1000548,
0x1000552,
0x1000535,
0x1000536,
0x100053a,
0x100055b,
0x100055c,
0x100055a,
0x1000568,
0x1000561,
0x1000562,
0x100055d,
0x1000579,
0x1000564,
0x1000571,
0x1000567,
0x100055c,
0x1000586,
0x1000589,
0x1000572,
0x1000563,
0x1000575,
0x1000570,
0x100058a,
0x100056b,
0x100057b,
0x1000584,
0x100056f,
0x100056d,
0x1000587,
0x100056c,
0x1000574,
0x1000576,
0x1000585,
0x100055e,
0x100057a,
0x1000583,
0x100055e,
0x100057c,
0x1000580,
0x100057d,
0x100055d,
0x1000577,
0x100055b,
0x1000573,
0x1000569,
0x100056e,
0x1000581,
0x100057f,
0x1000589,
0x100057e,
0x1000578,
0x1000582,
0x1000565,
0x100058a,
0x1000566,
0x100056a,
0x10081177,
0x10081247,
0xc3,
0x1008121c,
0x1008121b,
0x1008121d,
0xfe7a,
0x10081188,
0x100810d1,
0x10081175,
0x1008ff9b,
0x1008126e,
0x1008ff97,
0x1008ff11,
0x1008ff32,
0x1008ffb2,
0x1008ff12,
0x1008ff17,
0x1008ff31,
0x1008ff14,
0x1008ffb6,
0x1008ff16,
0x1008ff13,
0x1008ff99,
0x1008ff1c,
0x1008ff98,
0x1008ff3e,
0x1008ff15,
0x1008127d,
0x1008ff8d,
0x42,
0x1001e02,
0x1008ff26,
0x1008ff3f,
0xff08,
0x1000ff74,
0x1008ff93,
0xff58,
0x1008ffa6,
0x1008ff94,
0x1008ff52,
0xfe74,
0xff6b,
0x1008ff3b,
0x100810f4,
0x10081251,
0x10081250,
0x10081240,
0x6be,
0x6ae,
0x43,
0x1008ff53,
0xfea2,
0xfea5,
0xfea4,
0x2c5,
0x1c6,
0x1008ff54,
0x1008ff1d,
0x1008ff20,
0x1008124c,
0x1008124b,
0x1008124d,
0x10081218,
0x10081210,
0x10081219,
0x1008121a,
0x10081217,
0x10081215,
0x10081216,
0xff69,
0xffe5,
0x1c8,
0xc7,
0x2c6,
0xfea1,
0x10081193,
0x10081192,
0xff0b,
0x1008fe21,
0x1000ff6f,
0x10081286,
0x1008ff56,
0xff37,
0x10020a1,
0x1008ff3d,
0x1008ff70,
0x100811b6,
0x1008ff22,
0x10081243,
0xffe3,
0xffe4,
0x1008ff57,
0x10020a2,
0x1008ff58,
0x1008ff9c,
0x6e1,
0x6e2,
0x6fe,
0x10004b6,
0x10004b8,
0x6e4,
0x6bf,
0x6fc,
0x6e6,
0x6ec,
0x6ed,
0x6ee,
0x10004a2,
0x6f2,
0x6f3,
0x6e7,
0x1000492,
0x6e8,
0x6ff,
0x10004b2,
0x6e9,
0x6e5,
0x6b3,
0x10004e2,
0x6b8,
0x6eb,
0x100049a,
0x100049c,
0x6b9,
0x6ba,
0x6ef,
0x10004e8,
0x6f0,
0x10004d8,
0x6fb,
0x6fd,
0x10004ba,
0x6ea,
0x6f8,
0x6f4,
0x6e3,
0x6f5,
0x10004ee,
0x10004ae,
0x10004b0,
0x6f7,
0x6f1,
0x6f9,
0x6e0,
0x6fa,
0x6f6,
0x1000496,
0x6c1,
0x6c2,
0x6de,
0x10004b7,
0x10004b9,
0x6c4,
0x6af,
0x6dc,
0x6c6,
0x6cc,
0x6cd,
0x6ce,
0x10004a3,
0x6d2,
0x6d3,
0x6c7,
0x1000493,
0x6c8,
0x10004b3,
0x6df,
0x6c9,
0x10004e3,
0x6c5,
0x6a3,
0x6a8,
0x6cb,
0x100049b,
0x100049d,
0x6a9,
0x6aa,
0x6cf,
0x10004e9,
0x6d0,
0x10004d9,
0x6db,
0x6dd,
0x10004bb,
0x6ca,
0x6d8,
0x6d4,
0x6c3,
0x6d5,
0x10004ef,
0x10004af,
0x10004b1,
0x6d7,
0x6d1,
0x6d9,
0x6c0,
0x6da,
0x6d6,
0x1000497,
0x44,
0x1008ff5a,
0x1000ff00,
0x10081185,
0x1001e0a,
0x1000fe27,
0x10081277,
0x100811aa,
0x1cf,
0x1000fe2c,
0x1000fe5e,
0x1000fe22,
0xffff,
0x1000ff73,
0x1000ff71,
0x1000fe60,
0x1008124a,
0x1008ff59,
0x100810f5,
0x100811af,
0x1008124f,
0x1008ff5b,
0x10020ab,
0xff54,
0x1000feb0,
0x1d0,
0x1000fe7e,
0x10081283,
0x45,
0x3bd,
0xd0,
0x10001b7,
0x3cc,
0xc9,
0x1001eb8,
0x1cc,
0xca,
0x1001ebe,
0x1001ec6,
0x1001ec0,
0x1001ec2,
0x1001ec4,
0x10020a0,
0xcb,
0x100811a6,
0xc8,
0x1001eba,
0xff2f,
0xff30,
0x1008ff2c,
0x3aa,
0x10081249,
0xff57,
0x1ca,
0xff1b,
0xd0,
0x1001ebc,
0x20ac,
0x1008ff5c,
0xff62,
0x100810ae,
0x1008ff5d,
0x1000ff76,
0x1000ff77,
0x46,
0xffbe,
0xffc7,
0xffc8,
0xffc9,
0xffca,
0xffcb,
0xffcc,
0xffcd,
0xffce,
0xffcf,
0xffd0,
0xffbf,
0xffd1,
0xffd2,
0xffd3,
0xffd4,
0xffd5,
0xffd6,
0xffd7,
0xffd8,
0xffd9,
0xffda,
0xffc0,
0xffdb,
0xffdc,
0xffdd,
0xffde,
0xffdf,
0xffe0,
0xffc1,
0xffc2,
0xffc3,
0xffc4,
0xffc5,
0xffc6,
0x10020a3,
0x1001e1e,
0x10006f0,
0x10006f1,
0x10006f2,
0x10006f3,
0x10006f4,
0x10006f5,
0x10006f6,
0x10006f7,
0x10006f8,
0x10006f9,
0x10006cc,
0x10081275,
0x1008ff30,
0x1008ff3c,
0xff68,
0xfed0,
0x10081281,
0x100811d0,
0x100811e5,
0x100811de,
0x100811df,
0x100811e4,
0x100811e0,
0x100811e1,
0x100811d1,
0x100811e2,
0x100811d2,
0x100811db,
0x100811dc,
0x100811dd,
0x100811d3,
0x100811d4,
0x100811d5,
0x100811d6,
0x100811d7,
0x100811d8,
0x100811d9,
0x100811da,
0x100811e3,
0x1008ff27,
0x1008ff9d,
0x1008ff9e,
0x1008ffb8,
0x47,
0x2d5,
0x1008ff5e,
0x2ab,
0x10001e6,
0x3ab,
0x2d8,
0x10010d0,
0x10010d1,
0x10010ea,
0x10010ed,
0x10010e9,
0x10010ec,
0x10010d3,
0x10010d4,
0x10010f6,
0x10010d2,
0x10010e6,
0x10010f0,
0x10010f4,
0x10010f1,
0x10010f2,
0x10010f5,
0x10010d8,
0x10010ef,
0x10010eb,
0x10010d9,
0x10010e5,
0x10010da,
0x10010db,
0x10010dc,
0x10010dd,
0x10010de,
0x10010e4,
0x10010e7,
0x10010e0,
0x10010e1,
0x10010e8,
0x10010d7,
0x10010e2,
0x10010e3,
0x10010d5,
0x10010f3,
0x10010ee,
0x10010d6,
0x10010df,
0x1008ff5f,
0x10081162,
0x100811a8,
0x7c1,
0x7a1,
0x7c2,
0x7d7,
0x7c4,
0x7c5,
0x7a2,
0x7c7,
0x7a3,
0x7c3,
0x7c9,
0x7a4,
0x7a5,
0x7a5,
0x7ca,
0x7cb,
0x7cb,
0x7cc,
0x7cd,
0x7d9,
0x7ab,
0x7cf,
0x7a7,
0x7d6,
0x7d0,
0x7d8,
0x7d1,
0x7d2,
0x7d4,
0x7c8,
0x7d5,
0x7a8,
0x7a9,
0x7ce,
0x7c6,
0x7ae,
0x7e1,
0x7b1,
0x7e2,
0x7f7,
0x7e4,
0x7e5,
0x7b2,
0x7e7,
0x7b3,
0x7f3,
0x7e3,
0x7af,
0x7e9,
0x7b4,
0x7b6,
0x7b5,
0x7ea,
0x7eb,
0x7eb,
0x7ec,
0x7ed,
0x7f9,
0x7bb,
0x7ef,
0x7b7,
0x7f6,
0x7f0,
0x7f8,
0x7f1,
0x7f2,
0xff7e,
0x7f4,
0x7e8,
0x7f5,
0x7b8,
0x7ba,
0x7b9,
0x7ee,
0x7e6,
0x1008ffa4,
0x48,
0xff31,
0xebf,
0xec0,
0xef6,
0xef7,
0xff39,
0xeba,
0xff37,
0xea7,
0xec4,
0xec3,
0xed1,
0xff33,
0xff34,
0xebe,
0xed3,
0xeb7,
0xeea,
0xeda,
0xeee,
0xee8,
0xee9,
0xeeb,
0xed4,
0xed6,
0xef9,
0xee3,
0xed7,
0xed9,
0xed8,
0xef8,
0xeed,
0xee4,
0xee5,
0xedb,
0xee2,
0xedc,
0xedd,
0xee1,
0xede,
0xedf,
0xee0,
0xee6,
0xed5,
0xee7,
0xeec,
0xefa,
0xff35,
0xff38,
0xeb8,
0xebb,
0xea1,
0xea3,
0xef3,
0xeb1,
0xff3d,
0xea4,
0xea6,
0xea5,
0xec7,
0xeca,
0xef2,
0xebd,
0xeb2,
0xeb4,
0xff3b,
0xff3a,
0xff3e,
0xea9,
0xeb0,
0xeaa,
0xeab,
0xeaf,
0xeac,
0xead,
0xeae,
0xeef,
0xff36,
0xff3c,
0xeb5,
0xff3f,
0xea8,
0xeb9,
0xea2,
0xeb3,
0xeb6,
0xff32,
0xef0,
0xef4,
0xef1,
0xebc,
0xecc,
0xec8,
0xec9,
0xece,
0xecd,
0xecf,
0xec1,
0xec2,
0xec6,
0xec5,
0xed2,
0xecb,
0xed0,
0xef5,
0xff7e,
0x100811be,
0xff29,
0x2a6,
0xff7e,
0xff6a,
0xff23,
0xff23,
0x1008ffa8,
0xff25,
0xff27,
0x1008ff37,
0xff50,
0x1008ff18,
0x1008ff3a,
0x2a1,
0xffed,
0xffee,
0x49,
0x100000ee,
0xfe33,
0xfe30,
0xfe31,
0xfe32,
0xfe34,
0xfe2f,
0xfe2c,
0xfe2d,
0xfe2e,
0xfe0c,
0xfe0d,
0xfe06,
0xfe07,
0xff7e,
0xfe0e,
0xfe0f,
0xfe20,
0xfe02,
0xfe04,
0xfe05,
0xfe03,
0xfe12,
0xfe13,
0xfe11,
0xfe01,
0xfe22,
0xfe21,
0xfe08,
0xfe09,
0xfe24,
0xfe23,
0xfe25,
0xfe26,
0xfe0a,
0xfe0b,
0xfe2b,
0xfe29,
0xfe2a,
0xfe27,
0xfe28,
0x2a9,
0xcd,
0x1001eca,
0x100012c,
0xce,
0xcf,
0xcc,
0x1001ec8,
0x3cf,
0x100811ba,
0x10081166,
0xff63,
0x1000ff72,
0x1000ff70,
0x3c7,
0x3a5,
0x4a,
0x2ac,
0x10081242,
0x4b,
0xffb0,
0xffb1,
0xffb2,
0xffb3,
0xffb4,
0xffb5,
0xffb6,
0xffb7,
0xffb8,
0xffb9,
0xffab,
0x1000ff75,
0xff9d,
0xffae,
0xff9f,
0xffaf,
0xff99,
0xff9c,
0xff8d,
0xffbd,
0xff91,
0xff92,
0xff93,
0xff94,
0xff95,
0xff9e,
0xff96,
0xffaa,
0xff9b,
0xff9b,
0xff9a,
0xff9a,
0xff98,
0xffac,
0xff80,
0xffad,
0xff89,
0xff97,
0xff2d,
0xff2e,
0xff21,
0xff37,
0xff26,
0x1008ff06,
0x1008ff05,
0x10081264,
0x10081265,
0x10081261,
0x10081263,
0x10081260,
0x10081262,
0x100812b8,
0x100812b9,
0x100812ba,
0x100812bb,
0x100812bc,
0x1008ff04,
0x3d3,
0x1008ffb3,
0xeff,
0x4c,
0xffc8,
0xffd1,
0xffc9,
0xffca,
0xffcb,
0xffcc,
0xffcd,
0xffce,
0xffcf,
0xffd0,
0x1c5,
0xfed4,
0x1008ff40,
0x1008ff41,
0x1008ff42,
0x1008ff43,
0x1008ff44,
0x1008ff45,
0x1008ff46,
0x1008ff47,
0x1008ff48,
0x1008ff49,
0x1008ff4a,
0x1008ff4b,
0x1008ff4c,
0x1008ff4d,
0x1008ff4e,
0x1008ff4f,
0x1001e36,
0x1a5,
0x3a6,
0xff51,
0x10081269,
0x10081268,
0x1008ff35,
0x1008121e,
0xff0a,
0x100811bf,
0x10020a4,
0x1008fe25,
0x1008ff61,
0x1008fe24,
0x1a3,
0x4d,
0x1001e40,
0x6b5,
0x6b2,
0x6bc,
0x6a5,
0x6a2,
0x6ac,
0x10081290,
0x10081299,
0x1008129a,
0x1008129b,
0x1008129c,
0x1008129d,
0x1008129e,
0x1008129f,
0x100812a0,
0x100812a1,
0x100812a2,
0x10081291,
0x100812a3,
0x100812a4,
0x100812a5,
0x100812a6,
0x100812a7,
0x100812a8,
0x100812a9,
0x100812aa,
0x100812ab,
0x100812ac,
0x10081292,
0x100812ad,
0x10081293,
0x10081294,
0x10081295,
0x10081296,
0x10081297,
0x10081298,
0x100812b3,
0x100812b4,
0x100812b5,
0x100812b2,
0x100812b0,
0x100812b1,
0xff3e,
0x1008ff19,
0x1008ff90,
0x1008127e,
0x1008ff62,
0xff2c,
0x1008119b,
0x10081170,
0x100810a4,
0x10081199,
0x10081183,
0x100811b7,
0x10081186,
0x1008ff53,
0x1008117a,
0x10081185,
0x1008116e,
0x10081178,
0x1008116a,
0x10081181,
0x1008117d,
0x10081179,
0x10081180,
0x10081184,
0x10081182,
0x1008117b,
0x1008117c,
0x10081171,
0x1008126b,
0x1008ff63,
0x1008ff1e,
0xff67,
0x1008ff65,
0x1008ff66,
0x1008ff8e,
0xffe7,
0xffe8,
0x10020a5,
0x1008ff01,
0xff7e,
0x100810f4,
0x1008ff07,
0x1008ff03,
0x1008ff02,
0xfe77,
0xfe76,
0xff22,
0xff20,
0xff3d,
0x1008ff92,
0x1008ff33,
0x1008ff67,
0x4e,
0x1d1,
0x10020a6,
0x10081280,
0x10081288,
0x1d2,
0x3d1,
0x1008ff68,
0x10020aa,
0x1008ff69,
0xff56,
0x1008127b,
0x10081270,
0x1008fe22,
0xfed2,
0x0,
0x100811bc,
0xd1,
0xff7f,
0x1008119d,
0x10081200,
0x10081201,
0x1008126c,
0x1008126d,
0x10081202,
0x10081203,
0x10081204,
0x10081205,
0x10081206,
0x10081207,
0x10081208,
0x10081209,
0x1008120c,
0x1008120d,
0x1008120e,
0x1008120f,
0x1008120b,
0x1008120a,
0x4f,
0x13bc,
0x10081160,
0xd3,
0x100019f,
0x1001ecc,
0x10001d1,
0xd4,
0x1001ed0,
0x1001ed8,
0x1001ed2,
0x1001ed4,
0x1001ed6,
0xd6,
0x1d5,
0x1008ff6a,
0xd2,
0x1001ece,
0x10001a0,
0x1001eda,
0x1001ee2,
0x1001edc,
0x1001ede,
0x1001ee0,
0x3d2,
0x10081278,
0xd8,
0x1008ff6b,
0x1008ff38,
0x1008ff6c,
0xd8,
0xd5,
0xfe78,
0xfe79,
0x50,
0x1001e56,
0xff56,
0xff55,
0x1008ff6d,
0xff13,
0x10081272,
0x100812bd,
0x10020a7,
0x1008ff6e,
0x100811bd,
0x1008ff91,
0xfefa,
0xfee9,
0xfeea,
0xfeeb,
0xfeec,
0xfeed,
0xfee8,
0xfeef,
0xfef0,
0xfef1,
0xfef2,
0xfef3,
0xfeee,
0xfefb,
0xfefc,
0xfee3,
0xfee6,
0xfee7,
0xfef5,
0xfef6,
0xfef7,
0xfef8,
0xfefd,
0xfef4,
0xfef9,
0xfee0,
0xfee1,
0xfee2,
0xfee4,
0xfee5,
0x1008ff21,
0x1008ff2a,
0x100811a9,
0x1008fe23,
0xfed1,
0xff3e,
0x1008127c,
0xff61,
0xff55,
0x10081279,
0x51,
0x52,
0xffd2,
0xffdb,
0xffdc,
0xffdd,
0xffde,
0xffdf,
0xffe0,
0xffd3,
0xffd4,
0xffd5,
0xffd6,
0xffd7,
0xffd8,
0xffd9,
0xffda,
0x1008ffb5,
0x1c0,
0x10081284,
0x1d8,
0x3a3,
0x1008ffa3,
0xff66,
0x1008ff29,
0x10081232,
0x1008ff73,
0xfe72,
0x1008ff72,
0x1000ff6c,
0xff0d,
0xff53,
0x10081267,
0x10081266,
0x1008ff24,
0x1008ff25,
0x1008ff23,
0xff24,
0x1008126a,
0x1008ff74,
0x1008ff76,
0x1008ffb7,
0x1008ff75,
0x10020a8,
0x53,
0x100018f,
0x1001e60,
0x1a6,
0x1008ff77,
0x1a9,
0x1aa,
0x2de,
0x1008ff2d,
0x10081245,
0x1008ff7a,
0x1008ff79,
0x1008ff78,
0xff14,
0x1008ff1b,
0xff60,
0x1008ffa0,
0x1008127a,
0x1008ff7b,
0x6b1,
0x6bf,
0x6b8,
0x6b9,
0x6ba,
0x6bb,
0x6a1,
0x6af,
0x6a8,
0x6a9,
0x6aa,
0x6ab,
0xffe1,
0xffe6,
0xffe2,
0x1008ff36,
0x10081287,
0xff3c,
0x10081282,
0x1000d85,
0x1000d86,
0x1000dcf,
0x1000d87,
0x1000dd0,
0x1000d88,
0x1000dd1,
0x1000d93,
0x1000ddb,
0x1000dca,
0x1000d96,
0x1000dde,
0x1000db6,
0x1000db7,
0x1000da0,
0x1000da1,
0x1000da9,
0x1000daa,
0x1000daf,
0x1000db0,
0x1000d91,
0x1000dd9,
0x1000d92,
0x1000dda,
0x1000dc6,
0x1000d9c,
0x1000d9d,
0x1000d83,
0x1000dc4,
0x1000d89,
0x1000dd2,
0x1000d8a,
0x1000dd3,
0x1000da2,
0x1000da3,
0x1000da5,
0x1000d9a,
0x1000d9b,
0x1000df4,
0x1000dbd,
0x1000dc5,
0x1000d8f,
0x1000ddf,
0x1000d90,
0x1000df3,
0x1000db8,
0x1000db9,
0x1000db1,
0x1000dac,
0x1000db3,
0x1000d82,
0x1000d9e,
0x1000d9f,
0x1000da6,
0x1000dab,
0x1000da4,
0x1000d94,
0x1000ddc,
0x1000d95,
0x1000ddd,
0x1000db4,
0x1000db5,
0x1000dbb,
0x1000d8d,
0x1000d8e,
0x1000dd8,
0x1000df2,
0x1000dc3,
0x1000dc1,
0x1000dc2,
0x1000dad,
0x1000dae,
0x1000da7,
0x1000da8,
0x1000d8b,
0x1000dd4,
0x1000d8c,
0x1000dd6,
0x1000dc0,
0x1000dba,
0x1008ff2f,
0xfe73,
0x10081276,
0x1008127f,
0x1008ff7c,
0x100811b0,
0x1008ff7d,
0x100810dc,
0x1008ff10,
0x1008ff1a,
0xfe75,
0x1008ff28,
0x10081271,
0x1008ff9a,
0xff66,
0xff7e,
0x1005ff77,
0x1005ff78,
0x1005ff79,
0xff20,
0x1005ff72,
0x1005ff75,
0x1005ff10,
0x1005ff11,
0x1005ff03,
0x1005ff05,
0x1005ff01,
0x1005ff04,
0x1005ff00,
0x1005ff02,
0xff68,
0x1005ff71,
0x1005ff73,
0xff56,
0xff55,
0x1005ff74,
0x1005ff76,
0x1005ff7d,
0xff61,
0x1005ff70,
0xff69,
0x1005ff60,
0xff65,
0x1005ff7a,
0x1005ff7b,
0x1005ff7c,
0xffeb,
0xffec,
0x1008ff7e,
0x1008ffa7,
0x1008fe01,
0x1008fe0a,
0x1008fe0b,
0x1008fe0c,
0x1008fe02,
0x1008fe03,
0x1008fe04,
0x1008fe05,
0x1008fe06,
0x1008fe07,
0x1008fe08,
0x1008fe09,
0xff15,
0x1000ff6d,
0x54,
0xde,
0xff09,
0x1001e6a,
0x1008ff7f,
0x10081241,
0x1ab,
0x1de,
0x1008ff80,
0xfed5,
0xddf,
0xdba,
0xda8,
0xdaa,
0xda9,
0xdac,
0xdae,
0xdb4,
0xdbd,
0xdbf,
0xdcb,
0xdce,
0xda2,
0xda5,
0xda3,
0xda4,
0xda6,
0xda1,
0xde5,
0xdf7,
0xdf5,
0xdf6,
0xdf9,
0xdf1,
0xdf8,
0xdf3,
0xdf4,
0xdf2,
0xdf0,
0xdcc,
0xdc5,
0xdc6,
0xdeb,
0xde8,
0xdd1,
0xdde,
0xde7,
0xde9,
0xdea,
0xde6,
0xdc1,
0xda7,
0xded,
0xdb3,
0xdb9,
0xdcd,
0xdcf,
0xdda,
0xdbe,
0xdbc,
0xdc0,
0xdbb,
0xdc3,
0xdc4,
0xdd0,
0xdd2,
0xde1,
0xde4,
0xde3,
0xdd3,
0xde0,
0xdd4,
0xdd5,
0xde2,
0xdd8,
0xdd6,
0xdd7,
0xdd9,
0xdc9,
0xdc8,
0xdab,
0xdca,
0xdec,
0xdb1,
0xdb2,
0xdb7,
0xdb0,
0xdb8,
0xdb6,
0xdaf,
0xdb5,
0xdc7,
0xdc2,
0xdad,
0xde,
0x1008ff9f,
0x1008ff1f,
0x1008ff81,
0x1008ffa2,
0x1008ffb1,
0x1008ffb0,
0x1008ffa9,
0xff2b,
0x10081285,
0x1008ff82,
0x3ac,
0x55,
0xda,
0x1001ee4,
0x2dd,
0xdb,
0xdc,
0x1db,
0xd9,
0x1001ee6,
0x10001af,
0x1001ee8,
0x1001ef0,
0x1001eea,
0x1001eec,
0x1001eee,
0x6bd,
0x6b6,
0x6b4,
0x6b7,
0x6ad,
0x6a6,
0x6a4,
0x6a7,
0x6b6,
0x6b4,
0x6b7,
0x6a6,
0x6a4,
0x6a7,
0x3de,
0xff65,
0x1008fe20,
0x10081274,
0x3d9,
0xff52,
0x1d9,
0x1000ff6e,
0x1008ff85,
0x1008ff86,
0x1008ff84,
0x3dd,
0x56,
0x10081273,
0x1008ff34,
0x10081168,
0x1008ff87,
0x100811a0,
0x1008ffa1,
0x10081246,
0x100811ac,
0xffffff,
0x57,
0x1008ff95,
0x10081211,
0x1008ffb4,
0x1008ff2e,
0x1001e82,
0x1008ff2b,
0x1000174,
0x1001e84,
0x1008ff8f,
0x1001e80,
0x1008ff88,
0x1008ff55,
0x10020a9,
0x1008ff89,
0x58,
0x1001e8a,
0x1008ff8a,
0x59,
0xdd,
0x1001ef4,
0x1000176,
0x13be,
0x1008ffa5,
0x1001ef2,
0x1001ef6,
0x1001ef8,
0x5a,
0x1af,
0x1ac,
0x1ae,
0xff3d,
0xff28,
0xff2a,
0x1008ff8b,
0x1008ff8c,
0x100811a4,
0x10001b5,
0x61,
0xe1,
0x1001ea1,
0x1ff,
0x1e3,
0x1001eaf,
0x1001eb7,
0x1001eb1,
0x1001eb3,
0x1001eb5,
0xe2,
0x1001ea5,
0x1001ead,
0x1001ea7,
0x1001ea9,
0x1001eab,
0xb4,
0xe4,
0xe6,
0xe0,
0x1001ea3,
0x3e0,
0x26,
0x1b1,
0x27,
0x1002248,
0x8c8,
0xe5,
0x5e,
0x7e,
0x2a,
0x40,
0xe3,
0x62,
0x1001e03,
0x5c,
0xaf4,
0x7c,
0x1002235,
0x9df,
0x100000fc,
0x8a5,
0x8ac,
0x8a8,
0x8b2,
0x8ae,
0x8aa,
0x8b6,
0x9f6,
0x8b4,
0x7b,
0x7d,
0x5b,
0x5d,
0x1002800,
0xfff1,
0xfffa,
0xfff2,
0xfff3,
0xfff4,
0xfff5,
0xfff6,
0xfff7,
0xfff8,
0xfff9,
0x1002801,
0x1002803,
0x1002807,
0x100280f,
0x100281f,
0x100283f,
0x100287f,
0x10028ff,
0x10028bf,
0x100285f,
0x10028df,
0x100289f,
0x100282f,
0x100286f,
0x10028ef,
0x10028af,
0x100284f,
0x10028cf,
0x100288f,
0x1002817,
0x1002837,
0x1002877,
0x10028f7,
0x10028b7,
0x1002857,
0x10028d7,
0x1002897,
0x1002827,
0x1002867,
0x10028e7,
0x10028a7,
0x1002847,
0x10028c7,
0x1002887,
0x100280b,
0x100281b,
0x100283b,
0x100287b,
0x10028fb,
0x10028bb,
0x100285b,
0x10028db,
0x100289b,
0x100282b,
0x100286b,
0x10028eb,
0x10028ab,
0x100284b,
0x10028cb,
0x100288b,
0x1002813,
0x1002833,
0x1002873,
0x10028f3,
0x10028b3,
0x1002853,
0x10028d3,
0x1002893,
0x1002823,
0x1002863,
0x10028e3,
0x10028a3,
0x1002843,
0x10028c3,
0x1002883,
0x1002805,
0x100280d,
0x100281d,
0x100283d,
0x100287d,
0x10028fd,
0x10028bd,
0x100285d,
0x10028dd,
0x100289d,
0x100282d,
0x100286d,
0x10028ed,
0x10028ad,
0x100284d,
0x10028cd,
0x100288d,
0x1002815,
0x1002835,
0x1002875,
0x10028f5,
0x10028b5,
0x1002855,
0x10028d5,
0x1002895,
0x1002825,
0x1002865,
0x10028e5,
0x10028a5,
0x1002845,
0x10028c5,
0x1002885,
0x1002809,
0x1002819,
0x1002839,
0x1002879,
0x10028f9,
0x10028b9,
0x1002859,
0x10028d9,
0x1002899,
0x1002829,
0x1002869,
0x10028e9,
0x10028a9,
0x1002849,
0x10028c9,
0x1002889,
0x1002811,
0x1002831,
0x1002871,
0x10028f1,
0x10028b1,
0x1002851,
0x10028d1,
0x1002891,
0x1002821,
0x1002861,
0x10028e1,
0x10028a1,
0x1002841,
0x10028c1,
0x1002881,
0x1002802,
0x1002806,
0x100280e,
0x100281e,
0x100283e,
0x100287e,
0x10028fe,
0x10028be,
0x100285e,
0x10028de,
0x100289e,
0x100282e,
0x100286e,
0x10028ee,
0x10028ae,
0x100284e,
0x10028ce,
0x100288e,
0x1002816,
0x1002836,
0x1002876,
0x10028f6,
0x10028b6,
0x1002856,
0x10028d6,
0x1002896,
0x1002826,
0x1002866,
0x10028e6,
0x10028a6,
0x1002846,
0x10028c6,
0x1002886,
0x100280a,
0x100281a,
0x100283a,
0x100287a,
0x10028fa,
0x10028ba,
0x100285a,
0x10028da,
0x100289a,
0x100282a,
0x100286a,
0x10028ea,
0x10028aa,
0x100284a,
0x10028ca,
0x100288a,
0x1002812,
0x1002832,
0x1002872,
0x10028f2,
0x10028b2,
0x1002852,
0x10028d2,
0x1002892,
0x1002822,
0x1002862,
0x10028e2,
0x10028a2,
0x1002842,
0x10028c2,
0x1002882,
0x1002804,
0x100280c,
0x100281c,
0x100283c,
0x100287c,
0x10028fc,
0x10028bc,
0x100285c,
0x10028dc,
0x100289c,
0x100282c,
0x100286c,
0x10028ec,
0x10028ac,
0x100284c,
0x10028cc,
0x100288c,
0x1002814,
0x1002834,
0x1002874,
0x10028f4,
0x10028b4,
0x1002854,
0x10028d4,
0x1002894,
0x1002824,
0x1002864,
0x10028e4,
0x10028a4,
0x1002844,
0x10028c4,
0x1002884,
0x1002808,
0x1002818,
0x1002838,
0x1002878,
0x10028f8,
0x10028b8,
0x1002858,
0x10028d8,
0x1002898,
0x1002828,
0x1002868,
0x10028e8,
0x10028a8,
0x1002848,
0x10028c8,
0x1002888,
0x1002810,
0x1002830,
0x1002870,
0x10028f0,
0x10028b0,
0x1002850,
0x10028d0,
0x1002890,
0x1002820,
0x1002860,
0x10028e0,
0x10028a0,
0x1002840,
0x10028c0,
0x1002880,
0x1a2,
0xa6,
0x63,
0xfea3,
0x2e5,
0x1e6,
0xab8,
0xafc,
0x1b7,
0x1e8,
0xe7,
0x2e6,
0xb8,
0xa2,
0xfea0,
0x9e1,
0xaf3,
0xbcf,
0xaec,
0x3a,
0x1000301,
0x1000323,
0x1000300,
0x1000309,
0x1000303,
0x2c,
0x100220b,
0xa9,
0x9e4,
0x9ee,
0x100221b,
0xa4,
0xaff,
0x64,
0x1001e0b,
0xaf1,
0x1ef,
0xfe81,
0xfe83,
0xfe85,
0xfe87,
0xfe8b,
0xfe89,
0xfe80,
0xfe64,
0xfe56,
0xfe65,
0xfe58,
0xfe91,
0xfe51,
0xfe6b,
0xfe69,
0xfe6e,
0xfe6c,
0xfe60,
0xfe68,
0xfe67,
0xfe6a,
0xfe92,
0xfe55,
0xfe8b,
0xfe5a,
0xfe5b,
0xfe52,
0xfe6f,
0xfe65,
0xfe57,
0xfe59,
0xfe66,
0xfe82,
0xfe50,
0xfe8c,
0xfe8d,
0xfe61,
0xfe62,
0xfe84,
0xfe6d,
0xfe5d,
0xfe93,
0xfe90,
0xfe54,
0xfe86,
0xfe5c,
0xfe53,
0xfe64,
0xfe8a,
0xfe5f,
0xfe8a,
0xfe63,
0xfe53,
0xfe88,
0xfe5e,
0xabd,
0xb0,
0xa8,
0xaed,
0xaa5,
0x100222c,
0xf7,
0x24,
0xaaf,
0x1bd,
0xaf2,
0xafe,
0x8fe,
0xba8,
0xbd6,
0xbc4,
0xbc2,
0x1f0,
0x65,
0x3ec,
0xe9,
0x1001eb9,
0x1ec,
0xea,
0x1001ebf,
0x1001ec7,
0x1001ec1,
0x1001ec3,
0x1001ec5,
0xeb,
0xe8,
0x1001ebb,
0x1002088,
0x1002078,
0x1002208,
0xaae,
0xaa3,
0xaa4,
0x3ba,
0xaa9,
0xade,
0xadf,
0xace,
0xacf,
0x1002205,
0xaa1,
0xaaa,
0xae6,
0xae7,
0x3bf,
0xae0,
0xae1,
0xaa2,
0x1ea,
0x3d,
0xf0,
0x1001ebd,
0x21,
0xa1,
0x1000292,
0x66,
0x1001e1f,
0xaf8,
0x9e3,
0xabb,
0xadc,
0xadb,
0xadd,
0xae9,
0xae8,
0xac5,
0xab7,
0x1002085,
0x1002075,
0xab5,
0x1002084,
0x1002074,
0x100221c,
0x8f6,
0x67,
0x2f5,
0x2bb,
0x10001e7,
0x3bb,
0x2f8,
0x60,
0x3e,
0x8be,
0x100000be,
0xab,
0xbb,
0xab,
0xbb,
0x68,
0xaa8,
0x2b6,
0xaee,
0xce0,
0xcf2,
0xce1,
0xce1,
0xce7,
0xce3,
0xce3,
0xcdf,
0xcea,
0xced,
0xcef,
0xcf3,
0xcf5,
0xcf5,
0xce2,
0xce2,
0xce4,
0xce7,
0xceb,
0xcf7,
0xcec,
0xcee,
0xcf0,
0xcf4,
0xcf7,
0xcf8,
0xcf1,
0xcf1,
0xcf9,
0xcfa,
0xcfa,
0xce8,
0xce8,
0xce5,
0xce9,
0xcf6,
0xcf6,
0xce6,
0xce6,
0xada,
0x8a3,
0x9ef,
0x9f0,
0x9f1,
0x9f2,
0x9f3,
0x1000ff74,
0x1000ff6f,
0x1000ff73,
0x1000ff71,
0x100000ee,
0x1000ff72,
0x1000ff70,
0x1000ff75,
0x1000ff48,
0x1000ff49,
0x1000ff6c,
0x1000ff6d,
0x1000ff6e,
0x100000ee,
0x100000fc,
0x100000be,
0x100000af,
0x100000f6,
0x100000a8,
0x100000aa,
0x100000ac,
0x100000ab,
0x100000a9,
0x2b1,
0x9e2,
0xad,
0x69,
0x1008ff60,
0xed,
0x1001ecb,
0x100012d,
0xee,
0x8cf,
0xef,
0x2b9,
0x8cd,
0xec,
0x1001ec9,
0x3ef,
0x8ce,
0x8da,
0x8db,
0x8c2,
0x8bf,
0x8dc,
0x3e7,
0x3b5,
0x6a,
0x2bc,
0xbca,
0x6b,
0x4b1,
0x4c1,
0x4b4,
0x4cc,
0x4ca,
0x4cd,
0x4cb,
0x4ce,
0x4cc,
0x4b2,
0x4b6,
0x4b9,
0x4b7,
0x4ba,
0x4b8,
0x4cf,
0x4d2,
0x4d0,
0x4d3,
0x4d1,
0x4dd,
0x4c5,
0x4c8,
0x4c6,
0x4c9,
0x4c7,
0x4b5,
0x4d7,
0x4da,
0x4d8,
0x4db,
0x4d9,
0x4bb,
0x4be,
0x4bc,
0x4bf,
0x4bd,
0x4c0,
0x4c3,
0x4c1,
0x4c4,
0x4c2,
0x4c2,
0x4b3,
0x4dc,
0x4a6,
0x4d4,
0x4d6,
0x4d5,
0x4a7,
0x4a3,
0x4a4,
0x4a5,
0x4aa,
0x4a1,
0x4a8,
0x4a5,
0x4ab,
0x4a2,
0xff7e,
0x4af,
0x4af,
0x4a9,
0x4ac,
0x4ae,
0x4ad,
0x3a2,
0x3f3,
0x3a2,
0x6c,
0x1e5,
0xad9,
0x1001e37,
0x1b5,
0x3b6,
0xabc,
0x8fb,
0xba3,
0xad2,
0x8af,
0xacc,
0xaea,
0x8a1,
0xbda,
0xad0,
0x9f4,
0xbdc,
0x3c,
0x8bc,
0x9e5,
0x100000af,
0x8de,
0x8df,
0x100000f6,
0x9ed,
0x9ea,
0x1b3,
0x6d,
0x1001e41,
0xaf,
0xaf7,
0xaf0,
0xabf,
0xba,
0x2d,
0xad6,
0xb5,
0xd7,
0xaf6,
0xaf5,
0x100000a8,
0x100000aa,
0x100000ac,
0x100000ab,
0x100000a9,
0x6e,
0x8c5,
0x1f1,
0x1f2,
0x3f1,
0x1002089,
0x1002079,
0x9e8,
0xa0,
0x1002247,
0x1002209,
0x8bd,
0x1002262,
0xac,
0xf1,
0x23,
0x6b0,
0x6f,
0xf3,
0x1000275,
0x1001ecd,
0x10001d2,
0xf4,
0x1001ed1,
0x1001ed9,
0x1001ed3,
0x1001ed5,
0x1001ed7,
0xf6,
0x1f5,
0x13bd,
0x1b2,
0xf2,
0x1001ecf,
0x10001a1,
0x1001edb,
0x1001ee3,
0x1001edd,
0x1001edf,
0x1001ee1,
0x3f2,
0xac3,
0xab2,
0xbd,
0xbc,
0xab6,
0x1002081,
0xb9,
0xab0,
0xf8,
0xae2,
0xae5,
0xae4,
0xae3,
0xaa,
0xba,
0x1004ff44,
0x1004ff31,
0x1004ff08,
0x1004ff07,
0x1004ff5a,
0x1004ff58,
0x1004ff69,
0x1004ff0b,
0x1004ff02,
0x1004ff03,
0x1004ffff,
0x1004ff72,
0x1004ff54,
0x1004ff59,
0x1004ff57,
0x1004ff1b,
0x1004ff74,
0x1004ff6a,
0x1004ff63,
0x1004ff51,
0x1004ff67,
0x1004ff45,
0x1004ff5e,
0x1004ff5c,
0x1004ff42,
0x1004ff40,
0x1004ff43,
0x1004ff41,
0x1004ff04,
0x1004ff5d,
0x1004ff5b,
0x1004ff32,
0x1004ff33,
0x1004ff73,
0x1004ff78,
0x1004ff53,
0x1004ff60,
0x1004ff71,
0x1004ff65,
0x1004ff52,
0xf8,
0xf5,
0xbc0,
0x47e,
0x70,
0x1001e57,
0xb6,
0x28,
0x29,
0x1002202,
0x8ef,
0x25,
0x2e,
0xb7,
0xad5,
0xafb,
0x2b,
0xb1,
0xad4,
0x4b0,
0xaa6,
0x71,
0xbcc,
0x3f,
0xbf,
0x22,
0x60,
0x27,
0x72,
0x1e0,
0x8d6,
0x1f8,
0x3b3,
0xae,
0xabe,
0x8fd,
0xba6,
0xad3,
0x8b0,
0x8b7,
0xacd,
0xaeb,
0xbd8,
0xad1,
0x9f5,
0xbfc,
0x73,
0x1001e61,
0x1b6,
0x1b9,
0x1ba,
0x1000259,
0x2fe,
0xff7e,
0xad7,
0xa7,
0x3b,
0x4df,
0xac6,
0x1002087,
0x1002077,
0xaca,
0xaac,
0x8c9,
0xafd,
0x1002086,
0x1002076,
0x2f,
0x9e0,
0x20,
0x100221a,
0xdf,
0xa3,
0x1002263,
0x74,
0x1001e6b,
0x1bb,
0x1fe,
0xaf9,
0xafa,
0x8c0,
0xaa7,
0xfe,
0xac4,
0xab4,
0xbe,
0x1002083,
0xb3,
0x100222d,
0x8a4,
0x8ab,
0x8a2,
0x8a7,
0x8b1,
0x8ad,
0x8a9,
0x8b5,
0x9f7,
0x8b3,
0xac9,
0xacb,
0x3bc,
0xab3,
0x1002082,
0xb2,
0xab1,
0x75,
0xfa,
0x1001ee5,
0x2fd,
0xfb,
0xfc,
0x1fb,
0xf9,
0x1001ee7,
0x10001b0,
0x1001ee9,
0x1001ef1,
0x1001eeb,
0x1001eed,
0x1001eef,
0x3fe,
0xbc6,
0x5f,
0x8dd,
0x3f9,
0x8fc,
0xba9,
0x9ec,
0x9eb,
0xbc3,
0xbd3,
0xbce,
0x1f9,
0x3fd,
0x76,
0x8c1,
0x9f8,
0x8a6,
0x4de,
0x9e9,
0x77,
0x1001e83,
0x1000175,
0x1001e85,
0x1001e81,
0x78,
0x1001e8b,
0x79,
0xfd,
0x1001ef5,
0x1000177,
0xff,
0xa5,
0x1001ef3,
0x1001ef7,
0x1001ef9,
0x7a,
0x1bf,
0x1bc,
0x1be,
0x1002080,
0x1002070,
0x10001b6
};

static const struct KeyNameOffsetByValue {
    uint32_t sym;
    uint16_t offset;
} keyNameOffsetByValue[] _FCITX_UNUSED_ = {
{0x0, 1117},
{0x20, 2533},
{0x21, 2116},
{0x22, 2489},
{0x23, 2383},
{0x24, 2066},
{0x25, 2475},
{0x26, 1669},
{0x27, 1671},
{0x28, 2471},
{0x29, 2472},
{0x2a, 1677},
{0x2b, 2480},
{0x2c, 1992},
{0x2d, 2357},
{0x2e, 2476},
{0x2f, 2531},
{0x30, 0},
{0x31, 1},
{0x32, 4},
{0x33, 5},
{0x34, 37},
{0x35, 38},
{0x36, 39},
{0x37, 40},
{0x38, 41},
{0x39, 42},
{0x3a, 1986},
{0x3b, 2520},
{0x3c, 2340},
{0x3d, 2113},
{0x3e, 2145},
{0x3f, 2487},
{0x40, 1678},
{0x41, 43},
{0x42, 276},
{0x43, 296},
{0x44, 446},
{0x45, 474},
{0x46, 510},
{0x47, 591},
{0x48, 716},
{0x49, 840},
{0x4a, 898},
{0x4b, 901},
{0x4c, 962},
{0x4d, 1006},
{0x4e, 1102},
{0x4f, 1140},
{0x50, 1174},
{0x51, 1226},
{0x52, 1227},
{0x53, 1270},
{0x54, 1452},
{0x55, 1558},
{0x56, 1599},
{0x57, 1609},
{0x58, 1624},
{0x59, 1627},
{0x5a, 1636},
{0x5b, 1699},
{0x5c, 1682},
{0x5d, 1700},
{0x5e, 1675},
{0x5f, 2587},
{0x60, 2144},
{0x61, 1647},
{0x62, 1680},
{0x63, 1969},
{0x64, 2000},
{0x65, 2077},
{0x66, 2119},
{0x67, 2138},
{0x68, 2152},
{0x69, 2228},
{0x6a, 2249},
{0x6b, 2252},
{0x6c, 2322},
{0x6d, 2350},
{0x6e, 2368},
{0x6f, 2385},
{0x70, 2468},
{0x71, 2485},
{0x72, 2492},
{0x73, 2510},
{0x74, 2538},
{0x75, 2570},
{0x76, 2599},
{0x77, 2605},
{0x78, 2610},
{0x79, 2612},
{0x7a, 2621},
{0x7b, 1697},
{0x7c, 1684},
{0x7d, 1698},
{0x7e, 1676},
{0xa0, 2376},
{0xa1, 2117},
{0xa2, 1980},
{0xa3, 2536},
{0xa4, 1998},
{0xa5, 2617},
{0xa6, 1968},
{0xa7, 2519},
{0xa8, 2061},
{0xa9, 1994},
{0xaa, 2422},
{0xab, 2148},
{0xac, 2381},
{0xad, 2227},
{0xae, 2497},
{0xaf, 2352},
{0xb0, 2060},
{0xb1, 2481},
{0xb2, 2568},
{0xb3, 2551},
{0xb4, 1663},
{0xb5, 2359},
{0xb6, 2470},
{0xb7, 2477},
{0xb8, 1979},
{0xb9, 2415},
{0xba, 2356},
{0xbb, 2149},
{0xbc, 2412},
{0xbd, 2411},
{0xbe, 2549},
{0xbf, 2488},
{0xc0, 66},
{0xc1, 46},
{0xc2, 57},
{0xc3, 248},
{0xc4, 65},
{0xc5, 155},
{0xc6, 44},
{0xc7, 319},
{0xc8, 491},
{0xc9, 479},
{0xca, 482},
{0xcb, 489},
{0xcc, 888},
{0xcd, 883},
{0xce, 886},
{0xcf, 887},
{0xd0, 476},
{0xd1, 1119},
{0xd2, 1156},
{0xd3, 1143},
{0xd4, 1147},
{0xd5, 1171},
{0xd6, 1153},
{0xd7, 2360},
{0xd8, 1166},
{0xd9, 1565},
{0xda, 1559},
{0xdb, 1562},
{0xdc, 1563},
{0xdd, 1628},
{0xde, 1453},
{0xdf, 2535},
{0xe0, 1666},
{0xe1, 1648},
{0xe2, 1657},
{0xe3, 1679},
{0xe4, 1664},
{0xe5, 1674},
{0xe6, 1665},
{0xe7, 1977},
{0xe8, 2089},
{0xe9, 2079},
{0xea, 2082},
{0xeb, 2088},
{0xec, 2238},
{0xed, 2230},
{0xee, 2233},
{0xef, 2235},
{0xf0, 2114},
{0xf1, 2382},
{0xf2, 2400},
{0xf3, 2386},
{0xf4, 2390},
{0xf5, 2465},
{0xf6, 2396},
{0xf7, 2065},
{0xf8, 2417},
{0xf9, 2577},
{0xfa, 2571},
{0xfb, 2574},
{0xfc, 2575},
{0xfd, 2613},
{0xfe, 2546},
{0xff, 2616},
{0x1a1, 71},
{0x1a2, 1967},
{0x1a3, 1005},
{0x1a5, 992},
{0x1a6, 1273},
{0x1a9, 1275},
{0x1aa, 1276},
{0x1ab, 1458},
{0x1ac, 1638},
{0x1ae, 1639},
{0x1af, 1637},
{0x1b1, 1670},
{0x1b2, 2399},
{0x1b3, 2349},
{0x1b5, 2326},
{0x1b6, 2512},
{0x1b7, 1975},
{0x1b9, 2513},
{0x1ba, 2514},
{0x1bb, 2540},
{0x1bc, 2623},
{0x1bd, 2068},
{0x1be, 2624},
{0x1bf, 2622},
{0x1c0, 1244},
{0x1c3, 48},
{0x1c5, 973},
{0x1c6, 302},
{0x1c8, 318},
{0x1ca, 499},
{0x1cc, 481},
{0x1cf, 454},
{0x1d0, 471},
{0x1d1, 1103},
{0x1d2, 1107},
{0x1d5, 1154},
{0x1d8, 1246},
{0x1d9, 1593},
{0x1db, 1564},
{0x1de, 1459},
{0x1e0, 2493},
{0x1e3, 1651},
{0x1e5, 2323},
{0x1e6, 1972},
{0x1e8, 1976},
{0x1ea, 2112},
{0x1ec, 2081},
{0x1ef, 2003},
{0x1f0, 2076},
{0x1f1, 2370},
{0x1f2, 2371},
{0x1f5, 2397},
{0x1f8, 2495},
{0x1f9, 2597},
{0x1fb, 2576},
{0x1fe, 2541},
{0x1ff, 1650},
{0x2a1, 837},
{0x2a6, 825},
{0x2a9, 882},
{0x2ab, 594},
{0x2ac, 899},
{0x2b1, 2225},
{0x2b6, 2154},
{0x2b9, 2236},
{0x2bb, 2140},
{0x2bc, 2250},
{0x2c5, 301},
{0x2c6, 320},
{0x2d5, 592},
{0x2d8, 597},
{0x2dd, 1561},
{0x2de, 1277},
{0x2e5, 1971},
{0x2e6, 1978},
{0x2f5, 2139},
{0x2f8, 2143},
{0x2fd, 2573},
{0x2fe, 2516},
{0x3a2, 2319},
{0x3a3, 1247},
{0x3a5, 897},
{0x3a6, 993},
{0x3aa, 496},
{0x3ab, 596},
{0x3ac, 1557},
{0x3b3, 2496},
{0x3b5, 2248},
{0x3b6, 2327},
{0x3ba, 2097},
{0x3bb, 2142},
{0x3bc, 2565},
{0x3bd, 475},
{0x3bf, 2108},
{0x3c0, 70},
{0x3c7, 896},
{0x3cc, 478},
{0x3cf, 890},
{0x3d1, 1108},
{0x3d2, 1164},
{0x3d3, 959},
{0x3d9, 1591},
{0x3dd, 1598},
{0x3de, 1587},
{0x3e0, 1668},
{0x3e7, 2247},
{0x3ec, 2078},
{0x3ef, 2240},
{0x3f1, 2372},
{0x3f2, 2408},
{0x3f3, 2320},
{0x3f9, 2589},
{0x3fd, 2598},
{0x3fe, 2585},
{0x47e, 2467},
{0x4a1, 2307},
{0x4a2, 2311},
{0x4a3, 2303},
{0x4a4, 2304},
{0x4a5, 2305},
{0x4a6, 2298},
{0x4a7, 2302},
{0x4a8, 2308},
{0x4a9, 2315},
{0x4aa, 2306},
{0x4ab, 2310},
{0x4ac, 2316},
{0x4ad, 2318},
{0x4ae, 2317},
{0x4af, 2313},
{0x4b0, 2483},
{0x4b1, 2253},
{0x4b2, 2262},
{0x4b3, 2296},
{0x4b4, 2255},
{0x4b5, 2279},
{0x4b6, 2263},
{0x4b7, 2265},
{0x4b8, 2267},
{0x4b9, 2264},
{0x4ba, 2266},
{0x4bb, 2285},
{0x4bc, 2287},
{0x4bd, 2289},
{0x4be, 2286},
{0x4bf, 2288},
{0x4c0, 2290},
{0x4c1, 2254},
{0x4c2, 2294},
{0x4c3, 2291},
{0x4c4, 2293},
{0x4c5, 2274},
{0x4c6, 2276},
{0x4c7, 2278},
{0x4c8, 2275},
{0x4c9, 2277},
{0x4ca, 2257},
{0x4cb, 2259},
{0x4cc, 2256},
{0x4cd, 2258},
{0x4ce, 2260},
{0x4cf, 2268},
{0x4d0, 2270},
{0x4d1, 2272},
{0x4d2, 2269},
{0x4d3, 2271},
{0x4d4, 2299},
{0x4d5, 2301},
{0x4d6, 2300},
{0x4d7, 2280},
{0x4d8, 2282},
{0x4d9, 2284},
{0x4da, 2281},
{0x4db, 2283},
{0x4dc, 2297},
{0x4dd, 2273},
{0x4de, 2603},
{0x4df, 2521},
{0x5ac, 89},
{0x5bb, 135},
{0x5bf, 130},
{0x5c1, 104},
{0x5c2, 123},
{0x5c3, 107},
{0x5c4, 108},
{0x5c5, 110},
{0x5c6, 109},
{0x5c7, 86},
{0x5c8, 88},
{0x5c9, 145},
{0x5ca, 144},
{0x5cb, 147},
{0x5cc, 114},
{0x5cd, 103},
{0x5ce, 120},
{0x5cf, 91},
{0x5d0, 146},
{0x5d1, 131},
{0x5d2, 154},
{0x5d3, 134},
{0x5d4, 137},
{0x5d5, 133},
{0x5d6, 90},
{0x5d7, 141},
{0x5d8, 153},
{0x5d9, 85},
{0x5da, 101},
{0x5e0, 142},
{0x5e1, 98},
{0x5e2, 129},
{0x5e3, 116},
{0x5e4, 121},
{0x5e5, 124},
{0x5e6, 125},
{0x5e7, 102},
{0x5e8, 150},
{0x5e9, 87},
{0x5ea, 151},
{0x5eb, 97},
{0x5ec, 93},
{0x5ed, 118},
{0x5ee, 96},
{0x5ef, 92},
{0x5f0, 117},
{0x5f1, 136},
{0x5f2, 138},
{0x6a1, 1295},
{0x6a2, 1012},
{0x6a3, 417},
{0x6a4, 1579},
{0x6a5, 1011},
{0x6a6, 1578},
{0x6a7, 1580},
{0x6a8, 418},
{0x6a9, 422},
{0x6aa, 423},
{0x6ab, 1300},
{0x6ac, 1013},
{0x6ad, 1577},
{0x6ae, 295},
{0x6af, 400},
{0x6b0, 2384},
{0x6b1, 1289},
{0x6b2, 1009},
{0x6b3, 364},
{0x6b4, 1575},
{0x6b5, 1008},
{0x6b6, 1574},
{0x6b7, 1576},
{0x6b8, 366},
{0x6b9, 370},
{0x6ba, 371},
{0x6bb, 1294},
{0x6bc, 1010},
{0x6bd, 1573},
{0x6be, 294},
{0x6bf, 348},
{0x6c0, 442},
{0x6c1, 394},
{0x6c2, 395},
{0x6c3, 434},
{0x6c4, 399},
{0x6c5, 416},
{0x6c6, 402},
{0x6c7, 409},
{0x6c8, 411},
{0x6c9, 414},
{0x6ca, 431},
{0x6cb, 419},
{0x6cc, 403},
{0x6cd, 404},
{0x6ce, 405},
{0x6cf, 424},
{0x6d0, 426},
{0x6d1, 440},
{0x6d2, 407},
{0x6d3, 408},
{0x6d4, 433},
{0x6d5, 435},
{0x6d6, 444},
{0x6d7, 439},
{0x6d8, 432},
{0x6d9, 441},
{0x6da, 443},
{0x6db, 428},
{0x6dc, 401},
{0x6dd, 429},
{0x6de, 396},
{0x6df, 413},
{0x6e0, 390},
{0x6e1, 342},
{0x6e2, 343},
{0x6e3, 382},
{0x6e4, 347},
{0x6e5, 363},
{0x6e6, 350},
{0x6e7, 357},
{0x6e8, 359},
{0x6e9, 362},
{0x6ea, 379},
{0x6eb, 367},
{0x6ec, 351},
{0x6ed, 352},
{0x6ee, 353},
{0x6ef, 372},
{0x6f0, 374},
{0x6f1, 388},
{0x6f2, 355},
{0x6f3, 356},
{0x6f4, 381},
{0x6f5, 383},
{0x6f6, 392},
{0x6f7, 387},
{0x6f8, 380},
{0x6f9, 389},
{0x6fa, 391},
{0x6fb, 376},
{0x6fc, 349},
{0x6fd, 377},
{0x6fe, 344},
{0x6ff, 360},
{0x7a1, 641},
{0x7a2, 646},
{0x7a3, 648},
{0x7a4, 651},
{0x7a5, 652},
{0x7a7, 662},
{0x7a8, 671},
{0x7a9, 672},
{0x7ab, 660},
{0x7ae, 675},
{0x7af, 687},
{0x7b1, 677},
{0x7b2, 682},
{0x7b3, 684},
{0x7b4, 689},
{0x7b5, 691},
{0x7b6, 690},
{0x7b7, 700},
{0x7b8, 710},
{0x7b9, 712},
{0x7ba, 711},
{0x7bb, 698},
{0x7c1, 640},
{0x7c2, 642},
{0x7c3, 649},
{0x7c4, 644},
{0x7c5, 645},
{0x7c6, 674},
{0x7c7, 647},
{0x7c8, 669},
{0x7c9, 650},
{0x7ca, 654},
{0x7cb, 655},
{0x7cc, 657},
{0x7cd, 658},
{0x7ce, 673},
{0x7cf, 661},
{0x7d0, 664},
{0x7d1, 666},
{0x7d2, 667},
{0x7d4, 668},
{0x7d5, 670},
{0x7d6, 663},
{0x7d7, 643},
{0x7d8, 665},
{0x7d9, 659},
{0x7e1, 676},
{0x7e2, 678},
{0x7e3, 686},
{0x7e4, 680},
{0x7e5, 681},
{0x7e6, 714},
{0x7e7, 683},
{0x7e8, 708},
{0x7e9, 688},
{0x7ea, 692},
{0x7eb, 693},
{0x7ec, 695},
{0x7ed, 696},
{0x7ee, 713},
{0x7ef, 699},
{0x7f0, 702},
{0x7f1, 704},
{0x7f2, 705},
{0x7f3, 685},
{0x7f4, 707},
{0x7f5, 709},
{0x7f6, 701},
{0x7f7, 679},
{0x7f8, 703},
{0x7f9, 697},
{0x8a1, 2335},
{0x8a2, 2555},
{0x8a3, 2196},
{0x8a4, 2553},
{0x8a5, 1688},
{0x8a6, 2602},
{0x8a7, 2556},
{0x8a8, 1690},
{0x8a9, 2559},
{0x8aa, 1693},
{0x8ab, 2554},
{0x8ac, 1689},
{0x8ad, 2558},
{0x8ae, 1692},
{0x8af, 2332},
{0x8b0, 2502},
{0x8b1, 2557},
{0x8b2, 1691},
{0x8b3, 2562},
{0x8b4, 1696},
{0x8b5, 2560},
{0x8b6, 1694},
{0x8b7, 2503},
{0x8bc, 2341},
{0x8bd, 2379},
{0x8be, 2146},
{0x8bf, 2245},
{0x8c0, 2544},
{0x8c1, 2600},
{0x8c2, 2244},
{0x8c5, 2369},
{0x8c8, 1673},
{0x8c9, 2527},
{0x8cd, 2237},
{0x8ce, 2241},
{0x8cf, 2234},
{0x8d6, 2494},
{0x8da, 2242},
{0x8db, 2243},
{0x8dc, 2246},
{0x8dd, 2588},
{0x8de, 2344},
{0x8df, 2345},
{0x8ef, 2474},
{0x8f6, 2137},
{0x8fb, 2329},
{0x8fc, 2590},
{0x8fd, 2499},
{0x8fe, 2071},
{0x9df, 1686},
{0x9e0, 2532},
{0x9e1, 1982},
{0x9e2, 2226},
{0x9e3, 2122},
{0x9e4, 1995},
{0x9e5, 2342},
{0x9e8, 2375},
{0x9e9, 2604},
{0x9ea, 2348},
{0x9eb, 2593},
{0x9ec, 2592},
{0x9ed, 2347},
{0x9ee, 1996},
{0x9ef, 2197},
{0x9f0, 2198},
{0x9f1, 2199},
{0x9f2, 2200},
{0x9f3, 2201},
{0x9f4, 2338},
{0x9f5, 2508},
{0x9f6, 1695},
{0x9f7, 2561},
{0x9f8, 2601},
{0xaa1, 2104},
{0xaa2, 2111},
{0xaa3, 2095},
{0xaa4, 2096},
{0xaa5, 2063},
{0xaa6, 2484},
{0xaa7, 2545},
{0xaa8, 2153},
{0xaa9, 2098},
{0xaaa, 2105},
{0xaac, 2526},
{0xaae, 2094},
{0xaaf, 2067},
{0xab0, 2416},
{0xab1, 2569},
{0xab2, 2410},
{0xab3, 2566},
{0xab4, 2548},
{0xab5, 2133},
{0xab6, 2413},
{0xab7, 2130},
{0xab8, 1973},
{0xabb, 2123},
{0xabc, 2328},
{0xabd, 2059},
{0xabe, 2498},
{0xabf, 2355},
{0xac3, 2409},
{0xac4, 2547},
{0xac5, 2129},
{0xac6, 2522},
{0xac9, 2563},
{0xaca, 2525},
{0xacb, 2564},
{0xacc, 2333},
{0xacd, 2504},
{0xace, 2101},
{0xacf, 2102},
{0xad0, 2337},
{0xad1, 2507},
{0xad2, 2331},
{0xad3, 2501},
{0xad4, 2482},
{0xad5, 2478},
{0xad6, 2358},
{0xad7, 2518},
{0xad9, 2324},
{0xada, 2195},
{0xadb, 2125},
{0xadc, 2124},
{0xadd, 2126},
{0xade, 2099},
{0xadf, 2100},
{0xae0, 2109},
{0xae1, 2110},
{0xae2, 2418},
{0xae3, 2421},
{0xae4, 2420},
{0xae5, 2419},
{0xae6, 2106},
{0xae7, 2107},
{0xae8, 2128},
{0xae9, 2127},
{0xaea, 2334},
{0xaeb, 2505},
{0xaec, 1985},
{0xaed, 2062},
{0xaee, 2155},
{0xaf0, 2354},
{0xaf1, 2002},
{0xaf2, 2069},
{0xaf3, 1983},
{0xaf4, 1683},
{0xaf5, 2362},
{0xaf6, 2361},
{0xaf7, 2353},
{0xaf8, 2121},
{0xaf9, 2542},
{0xafa, 2543},
{0xafb, 2479},
{0xafc, 1974},
{0xafd, 2528},
{0xafe, 2070},
{0xaff, 1999},
{0xba3, 2330},
{0xba6, 2500},
{0xba8, 2072},
{0xba9, 2591},
{0xbc0, 2466},
{0xbc2, 2075},
{0xbc3, 2594},
{0xbc4, 2074},
{0xbc6, 2586},
{0xbca, 2251},
{0xbcc, 2486},
{0xbce, 2596},
{0xbcf, 1984},
{0xbd3, 2595},
{0xbd6, 2073},
{0xbd8, 2506},
{0xbda, 2336},
{0xbdc, 2339},
{0xbfc, 2509},
{0xcdf, 2163},
{0xce0, 2156},
{0xce1, 2158},
{0xce2, 2170},
{0xce3, 2161},
{0xce4, 2172},
{0xce5, 2189},
{0xce6, 2193},
{0xce7, 2160},
{0xce8, 2187},
{0xce9, 2190},
{0xcea, 2164},
{0xceb, 2174},
{0xcec, 2176},
{0xced, 2165},
{0xcee, 2177},
{0xcef, 2166},
{0xcf0, 2178},
{0xcf1, 2182},
{0xcf2, 2157},
{0xcf3, 2167},
{0xcf4, 2179},
{0xcf5, 2168},
{0xcf6, 2191},
{0xcf7, 2175},
{0xcf8, 2181},
{0xcf9, 2184},
{0xcfa, 2185},
{0xda1, 1479},
{0xda2, 1474},
{0xda3, 1476},
{0xda4, 1477},
{0xda5, 1475},
{0xda6, 1478},
{0xda7, 1503},
{0xda8, 1464},
{0xda9, 1466},
{0xdaa, 1465},
{0xdab, 1532},
{0xdac, 1467},
{0xdad, 1545},
{0xdae, 1468},
{0xdaf, 1541},
{0xdb0, 1538},
{0xdb1, 1535},
{0xdb2, 1536},
{0xdb3, 1505},
{0xdb4, 1469},
{0xdb5, 1542},
{0xdb6, 1540},
{0xdb7, 1537},
{0xdb8, 1539},
{0xdb9, 1506},
{0xdba, 1463},
{0xdbb, 1513},
{0xdbc, 1511},
{0xdbd, 1470},
{0xdbe, 1510},
{0xdbf, 1471},
{0xdc0, 1512},
{0xdc1, 1502},
{0xdc2, 1544},
{0xdc3, 1514},
{0xdc4, 1515},
{0xdc5, 1492},
{0xdc6, 1493},
{0xdc7, 1543},
{0xdc8, 1531},
{0xdc9, 1530},
{0xdca, 1533},
{0xdcb, 1472},
{0xdcc, 1491},
{0xdcd, 1507},
{0xdce, 1473},
{0xdcf, 1508},
{0xdd0, 1516},
{0xdd1, 1496},
{0xdd2, 1517},
{0xdd3, 1521},
{0xdd4, 1523},
{0xdd5, 1524},
{0xdd6, 1527},
{0xdd7, 1528},
{0xdd8, 1526},
{0xdd9, 1529},
{0xdda, 1509},
{0xdde, 1497},
{0xddf, 1462},
{0xde0, 1522},
{0xde1, 1518},
{0xde2, 1525},
{0xde3, 1520},
{0xde4, 1519},
{0xde5, 1480},
{0xde6, 1501},
{0xde7, 1498},
{0xde8, 1495},
{0xde9, 1499},
{0xdea, 1500},
{0xdeb, 1494},
{0xdec, 1534},
{0xded, 1504},
{0xdf0, 1490},
{0xdf1, 1485},
{0xdf2, 1489},
{0xdf3, 1487},
{0xdf4, 1488},
{0xdf5, 1482},
{0xdf6, 1483},
{0xdf7, 1481},
{0xdf8, 1486},
{0xdf9, 1484},
{0xea1, 768},
{0xea2, 800},
{0xea3, 769},
{0xea4, 773},
{0xea5, 775},
{0xea6, 774},
{0xea7, 725},
{0xea8, 798},
{0xea9, 785},
{0xeaa, 787},
{0xeab, 788},
{0xeac, 790},
{0xead, 791},
{0xeae, 792},
{0xeaf, 789},
{0xeb0, 786},
{0xeb1, 771},
{0xeb2, 780},
{0xeb3, 801},
{0xeb4, 781},
{0xeb5, 796},
{0xeb6, 802},
{0xeb7, 733},
{0xeb8, 766},
{0xeb9, 799},
{0xeba, 723},
{0xebb, 767},
{0xebc, 807},
{0xebd, 779},
{0xebe, 731},
{0xebf, 718},
{0xec0, 719},
{0xec1, 814},
{0xec2, 815},
{0xec3, 727},
{0xec4, 726},
{0xec5, 817},
{0xec6, 816},
{0xec7, 776},
{0xec8, 809},
{0xec9, 810},
{0xeca, 777},
{0xecb, 819},
{0xecc, 808},
{0xecd, 812},
{0xece, 811},
{0xecf, 813},
{0xed0, 820},
{0xed1, 728},
{0xed2, 818},
{0xed3, 732},
{0xed4, 740},
{0xed5, 760},
{0xed6, 741},
{0xed7, 744},
{0xed8, 746},
{0xed9, 745},
{0xeda, 735},
{0xedb, 751},
{0xedc, 753},
{0xedd, 754},
{0xede, 756},
{0xedf, 757},
{0xee0, 758},
{0xee1, 755},
{0xee2, 752},
{0xee3, 743},
{0xee4, 749},
{0xee5, 750},
{0xee6, 759},
{0xee7, 761},
{0xee8, 737},
{0xee9, 738},
{0xeea, 734},
{0xeeb, 739},
{0xeec, 762},
{0xeed, 748},
{0xeee, 736},
{0xeef, 793},
{0xef0, 804},
{0xef1, 806},
{0xef2, 778},
{0xef3, 770},
{0xef4, 805},
{0xef5, 821},
{0xef6, 720},
{0xef7, 721},
{0xef8, 747},
{0xef9, 742},
{0xefa, 763},
{0xeff, 961},
{0x13bc, 1141},
{0x13bd, 2398},
{0x13be, 1631},
{0x20ac, 503},
{0xfd01, 14},
{0xfd02, 19},
{0xfd03, 32},
{0xfd04, 23},
{0xfd05, 8},
{0xfd06, 16},
{0xfd07, 17},
{0xfd08, 31},
{0xfd09, 29},
{0xfd0a, 24},
{0xfd0b, 25},
{0xfd0c, 26},
{0xfd0d, 35},
{0xfd0e, 7},
{0xfd0f, 11},
{0xfd10, 6},
{0xfd11, 22},
{0xfd12, 21},
{0xfd13, 20},
{0xfd14, 33},
{0xfd15, 10},
{0xfd16, 27},
{0xfd17, 34},
{0xfd18, 30},
{0xfd19, 9},
{0xfd1a, 13},
{0xfd1b, 18},
{0xfd1c, 12},
{0xfd1d, 28},
{0xfd1e, 15},
{0xfe01, 866},
{0xfe02, 859},
{0xfe03, 862},
{0xfe04, 860},
{0xfe05, 861},
{0xfe06, 853},
{0xfe07, 854},
{0xfe08, 869},
{0xfe09, 870},
{0xfe0a, 875},
{0xfe0b, 876},
{0xfe0c, 851},
{0xfe0d, 852},
{0xfe0e, 856},
{0xfe0f, 857},
{0xfe11, 865},
{0xfe12, 863},
{0xfe13, 864},
{0xfe20, 858},
{0xfe21, 868},
{0xfe22, 867},
{0xfe23, 872},
{0xfe24, 871},
{0xfe25, 873},
{0xfe26, 874},
{0xfe27, 880},
{0xfe28, 881},
{0xfe29, 878},
{0xfe2a, 879},
{0xfe2b, 877},
{0xfe2c, 848},
{0xfe2d, 849},
{0xfe2e, 850},
{0xfe2f, 847},
{0xfe30, 843},
{0xfe31, 844},
{0xfe32, 845},
{0xfe33, 842},
{0xfe34, 846},
{0xfe50, 2037},
{0xfe51, 2016},
{0xfe52, 2030},
{0xfe53, 2050},
{0xfe54, 2047},
{0xfe55, 2026},
{0xfe56, 2012},
{0xfe57, 2033},
{0xfe58, 2014},
{0xfe59, 2034},
{0xfe5a, 2028},
{0xfe5b, 2029},
{0xfe5c, 2049},
{0xfe5d, 2044},
{0xfe5e, 2058},
{0xfe5f, 2053},
{0xfe60, 2021},
{0xfe61, 2040},
{0xfe62, 2041},
{0xfe63, 2055},
{0xfe64, 2011},
{0xfe65, 2013},
{0xfe66, 2035},
{0xfe67, 2023},
{0xfe68, 2022},
{0xfe69, 2018},
{0xfe6a, 2024},
{0xfe6b, 2017},
{0xfe6c, 2020},
{0xfe6d, 2043},
{0xfe6e, 2019},
{0xfe6f, 2031},
{0xfe70, 54},
{0xfe71, 55},
{0xfe72, 1253},
{0xfe73, 1389},
{0xfe74, 287},
{0xfe75, 1398},
{0xfe76, 1095},
{0xfe77, 1094},
{0xfe78, 1172},
{0xfe79, 1173},
{0xfe7a, 252},
{0xfe80, 2010},
{0xfe81, 2004},
{0xfe82, 2036},
{0xfe83, 2005},
{0xfe84, 2042},
{0xfe85, 2006},
{0xfe86, 2048},
{0xfe87, 2007},
{0xfe88, 2057},
{0xfe89, 2009},
{0xfe8a, 2052},
{0xfe8b, 2008},
{0xfe8c, 2038},
{0xfe8d, 2039},
{0xfe90, 2046},
{0xfe91, 2015},
{0xfe92, 2025},
{0xfe93, 2045},
{0xfea0, 1981},
{0xfea1, 321},
{0xfea2, 298},
{0xfea3, 1970},
{0xfea4, 300},
{0xfea5, 299},
{0xfed0, 563},
{0xfed1, 1220},
{0xfed2, 1116},
{0xfed4, 974},
{0xfed5, 1461},
{0xfee0, 1211},
{0xfee1, 1212},
{0xfee2, 1213},
{0xfee3, 1201},
{0xfee4, 1214},
{0xfee5, 1215},
{0xfee6, 1202},
{0xfee7, 1203},
{0xfee8, 1192},
{0xfee9, 1187},
{0xfeea, 1188},
{0xfeeb, 1189},
{0xfeec, 1190},
{0xfeed, 1191},
{0xfeee, 1198},
{0xfeef, 1193},
{0xfef0, 1194},
{0xfef1, 1195},
{0xfef2, 1196},
{0xfef3, 1197},
{0xfef4, 1209},
{0xfef5, 1204},
{0xfef6, 1205},
{0xfef7, 1206},
{0xfef8, 1207},
{0xfef9, 1210},
{0xfefa, 1186},
{0xfefb, 1199},
{0xfefc, 1200},
{0xfefd, 1208},
{0xff08, 280},
{0xff09, 1454},
{0xff0a, 999},
{0xff0b, 324},
{0xff0d, 1256},
{0xff13, 1179},
{0xff14, 1283},
{0xff15, 1450},
{0xff1b, 500},
{0xff20, 1097},
{0xff21, 942},
{0xff22, 1096},
{0xff23, 828},
{0xff24, 1263},
{0xff25, 831},
{0xff26, 944},
{0xff27, 832},
{0xff28, 1641},
{0xff29, 824},
{0xff2a, 1642},
{0xff2b, 1554},
{0xff2c, 1055},
{0xff2d, 940},
{0xff2e, 941},
{0xff2f, 493},
{0xff30, 494},
{0xff31, 717},
{0xff32, 803},
{0xff33, 729},
{0xff34, 730},
{0xff35, 764},
{0xff36, 794},
{0xff37, 329},
{0xff38, 765},
{0xff39, 722},
{0xff3a, 783},
{0xff3b, 782},
{0xff3c, 795},
{0xff3d, 772},
{0xff3e, 784},
{0xff3f, 797},
{0xff50, 834},
{0xff51, 994},
{0xff52, 1592},
{0xff53, 1257},
{0xff54, 469},
{0xff55, 1177},
{0xff56, 1112},
{0xff57, 498},
{0xff58, 283},
{0xff60, 1285},
{0xff61, 1223},
{0xff62, 505},
{0xff63, 893},
{0xff65, 1430},
{0xff66, 1249},
{0xff67, 1081},
{0xff68, 562},
{0xff69, 316},
{0xff6a, 827},
{0xff6b, 288},
{0xff7e, 140},
{0xff7f, 1120},
{0xff80, 936},
{0xff89, 938},
{0xff8d, 920},
{0xff91, 922},
{0xff92, 923},
{0xff93, 924},
{0xff94, 925},
{0xff95, 926},
{0xff96, 928},
{0xff97, 939},
{0xff98, 934},
{0xff99, 918},
{0xff9a, 932},
{0xff9b, 930},
{0xff9c, 919},
{0xff9d, 914},
{0xff9e, 927},
{0xff9f, 916},
{0xffaa, 929},
{0xffab, 912},
{0xffac, 935},
{0xffad, 937},
{0xffae, 915},
{0xffaf, 917},
{0xffb0, 902},
{0xffb1, 903},
{0xffb2, 904},
{0xffb3, 905},
{0xffb4, 906},
{0xffb5, 907},
{0xffb6, 908},
{0xffb7, 909},
{0xffb8, 910},
{0xffb9, 911},
{0xffbd, 921},
{0xffbe, 511},
{0xffbf, 522},
{0xffc0, 533},
{0xffc1, 540},
{0xffc2, 541},
{0xffc3, 542},
{0xffc4, 543},
{0xffc5, 544},
{0xffc6, 545},
{0xffc7, 512},
{0xffc8, 513},
{0xffc9, 514},
{0xffca, 515},
{0xffcb, 516},
{0xffcc, 517},
{0xffcd, 518},
{0xffce, 519},
{0xffcf, 520},
{0xffd0, 521},
{0xffd1, 523},
{0xffd2, 524},
{0xffd3, 525},
{0xffd4, 526},
{0xffd5, 527},
{0xffd6, 528},
{0xffd7, 529},
{0xffd8, 530},
{0xffd9, 531},
{0xffda, 532},
{0xffdb, 534},
{0xffdc, 535},
{0xffdd, 536},
{0xffde, 537},
{0xffdf, 538},
{0xffe0, 539},
{0xffe1, 1301},
{0xffe2, 1303},
{0xffe3, 336},
{0xffe4, 337},
{0xffe5, 317},
{0xffe6, 1302},
{0xffe7, 1085},
{0xffe8, 1086},
{0xffe9, 68},
{0xffea, 69},
{0xffeb, 1434},
{0xffec, 1435},
{0xffed, 838},
{0xffee, 839},
{0xfff1, 1702},
{0xfff2, 1704},
{0xfff3, 1705},
{0xfff4, 1706},
{0xfff5, 1707},
{0xfff6, 1708},
{0xfff7, 1709},
{0xfff8, 1710},
{0xfff9, 1711},
{0xfffa, 1703},
{0xffff, 458},
{0xffffff, 1608},
{0x100012c, 885},
{0x100012d, 2232},
{0x1000174, 1616},
{0x1000175, 2607},
{0x1000176, 1630},
{0x1000177, 2615},
{0x100018f, 1271},
{0x100019f, 1144},
{0x10001a0, 1158},
{0x10001a1, 2402},
{0x10001af, 1567},
{0x10001b0, 2579},
{0x10001b5, 1646},
{0x10001b6, 2627},
{0x10001b7, 477},
{0x10001d1, 1146},
{0x10001d2, 2389},
{0x10001e6, 595},
{0x10001e7, 2141},
{0x1000259, 2515},
{0x1000275, 2387},
{0x1000292, 2118},
{0x1000300, 1989},
{0x1000301, 1987},
{0x1000303, 1991},
{0x1000309, 1990},
{0x1000323, 1988},
{0x1000492, 358},
{0x1000493, 410},
{0x1000496, 393},
{0x1000497, 445},
{0x100049a, 368},
{0x100049b, 420},
{0x100049c, 369},
{0x100049d, 421},
{0x10004a2, 354},
{0x10004a3, 406},
{0x10004ae, 385},
{0x10004af, 437},
{0x10004b0, 386},
{0x10004b1, 438},
{0x10004b2, 361},
{0x10004b3, 412},
{0x10004b6, 345},
{0x10004b7, 397},
{0x10004b8, 346},
{0x10004b9, 398},
{0x10004ba, 378},
{0x10004bb, 430},
{0x10004d8, 375},
{0x10004d9, 427},
{0x10004e2, 365},
{0x10004e3, 415},
{0x10004e8, 373},
{0x10004e9, 425},
{0x10004ee, 384},
{0x10004ef, 436},
{0x1000531, 157},
{0x1000532, 158},
{0x1000533, 165},
{0x1000534, 160},
{0x1000535, 191},
{0x1000536, 192},
{0x1000537, 162},
{0x1000538, 156},
{0x1000539, 184},
{0x100053a, 193},
{0x100053b, 168},
{0x100053c, 173},
{0x100053d, 172},
{0x100053e, 185},
{0x100053f, 171},
{0x1000540, 167},
{0x1000541, 161},
{0x1000542, 164},
{0x1000543, 183},
{0x1000544, 174},
{0x1000545, 166},
{0x1000546, 175},
{0x1000547, 182},
{0x1000548, 189},
{0x1000549, 159},
{0x100054a, 177},
{0x100054b, 169},
{0x100054c, 179},
{0x100054d, 181},
{0x100054e, 188},
{0x100054f, 187},
{0x1000550, 180},
{0x1000551, 186},
{0x1000552, 190},
{0x1000553, 178},
{0x1000554, 170},
{0x1000555, 176},
{0x1000556, 163},
{0x100055a, 196},
{0x100055b, 194},
{0x100055c, 195},
{0x100055d, 200},
{0x100055e, 223},
{0x1000561, 198},
{0x1000562, 199},
{0x1000563, 209},
{0x1000564, 202},
{0x1000565, 242},
{0x1000566, 244},
{0x1000567, 204},
{0x1000568, 197},
{0x1000569, 234},
{0x100056a, 245},
{0x100056b, 213},
{0x100056c, 219},
{0x100056d, 217},
{0x100056e, 235},
{0x100056f, 216},
{0x1000570, 211},
{0x1000571, 203},
{0x1000572, 208},
{0x1000573, 233},
{0x1000574, 220},
{0x1000575, 210},
{0x1000576, 221},
{0x1000577, 231},
{0x1000578, 240},
{0x1000579, 201},
{0x100057a, 224},
{0x100057b, 214},
{0x100057c, 227},
{0x100057d, 229},
{0x100057e, 239},
{0x100057f, 237},
{0x1000580, 228},
{0x1000581, 236},
{0x1000582, 241},
{0x1000583, 225},
{0x1000584, 215},
{0x1000585, 222},
{0x1000586, 206},
{0x1000587, 218},
{0x1000589, 207},
{0x100058a, 212},
{0x1000653, 122},
{0x1000654, 105},
{0x1000655, 106},
{0x1000660, 75},
{0x1000661, 76},
{0x1000662, 77},
{0x1000663, 78},
{0x1000664, 79},
{0x1000665, 80},
{0x1000666, 81},
{0x1000667, 82},
{0x1000668, 83},
{0x1000669, 84},
{0x100066a, 128},
{0x1000670, 139},
{0x1000679, 148},
{0x100067e, 127},
{0x1000686, 143},
{0x1000688, 94},
{0x1000691, 132},
{0x1000698, 115},
{0x10006a4, 149},
{0x10006a9, 119},
{0x10006af, 100},
{0x10006ba, 126},
{0x10006be, 112},
{0x10006c1, 113},
{0x10006cc, 95},
{0x10006d2, 152},
{0x10006d4, 99},
{0x10006f0, 548},
{0x10006f1, 549},
{0x10006f2, 550},
{0x10006f3, 551},
{0x10006f4, 552},
{0x10006f5, 553},
{0x10006f6, 554},
{0x10006f7, 555},
{0x10006f8, 556},
{0x10006f9, 557},
{0x1000d82, 1358},
{0x1000d83, 1335},
{0x1000d85, 1308},
{0x1000d86, 1309},
{0x1000d87, 1311},
{0x1000d88, 1313},
{0x1000d89, 1337},
{0x1000d8a, 1339},
{0x1000d8b, 1382},
{0x1000d8c, 1384},
{0x1000d8d, 1371},
{0x1000d8e, 1372},
{0x1000d8f, 1349},
{0x1000d90, 1351},
{0x1000d91, 1328},
{0x1000d92, 1330},
{0x1000d93, 1315},
{0x1000d94, 1364},
{0x1000d95, 1366},
{0x1000d96, 1318},
{0x1000d9a, 1344},
{0x1000d9b, 1345},
{0x1000d9c, 1333},
{0x1000d9d, 1334},
{0x1000d9e, 1359},
{0x1000d9f, 1360},
{0x1000da0, 1322},
{0x1000da1, 1323},
{0x1000da2, 1341},
{0x1000da3, 1342},
{0x1000da4, 1363},
{0x1000da5, 1343},
{0x1000da6, 1361},
{0x1000da7, 1380},
{0x1000da8, 1381},
{0x1000da9, 1324},
{0x1000daa, 1325},
{0x1000dab, 1362},
{0x1000dac, 1356},
{0x1000dad, 1378},
{0x1000dae, 1379},
{0x1000daf, 1326},
{0x1000db0, 1327},
{0x1000db1, 1355},
{0x1000db3, 1357},
{0x1000db4, 1368},
{0x1000db5, 1369},
{0x1000db6, 1320},
{0x1000db7, 1321},
{0x1000db8, 1353},
{0x1000db9, 1354},
{0x1000dba, 1387},
{0x1000dbb, 1370},
{0x1000dbd, 1347},
{0x1000dc0, 1386},
{0x1000dc1, 1376},
{0x1000dc2, 1377},
{0x1000dc3, 1375},
{0x1000dc4, 1336},
{0x1000dc5, 1348},
{0x1000dc6, 1332},
{0x1000dca, 1317},
{0x1000dcf, 1310},
{0x1000dd0, 1312},
{0x1000dd1, 1314},
{0x1000dd2, 1338},
{0x1000dd3, 1340},
{0x1000dd4, 1383},
{0x1000dd6, 1385},
{0x1000dd8, 1373},
{0x1000dd9, 1329},
{0x1000dda, 1331},
{0x1000ddb, 1316},
{0x1000ddc, 1365},
{0x1000ddd, 1367},
{0x1000dde, 1319},
{0x1000ddf, 1350},
{0x1000df2, 1374},
{0x1000df3, 1352},
{0x1000df4, 1346},
{0x10010d0, 598},
{0x10010d1, 599},
{0x10010d2, 607},
{0x10010d3, 604},
{0x10010d4, 605},
{0x10010d5, 632},
{0x10010d6, 635},
{0x10010d7, 629},
{0x10010d8, 614},
{0x10010d9, 617},
{0x10010da, 619},
{0x10010db, 620},
{0x10010dc, 621},
{0x10010dd, 622},
{0x10010de, 623},
{0x10010df, 636},
{0x10010e0, 626},
{0x10010e1, 627},
{0x10010e2, 630},
{0x10010e3, 631},
{0x10010e4, 624},
{0x10010e5, 618},
{0x10010e6, 608},
{0x10010e7, 625},
{0x10010e8, 628},
{0x10010e9, 602},
{0x10010ea, 600},
{0x10010eb, 616},
{0x10010ec, 603},
{0x10010ed, 601},
{0x10010ee, 634},
{0x10010ef, 615},
{0x10010f0, 609},
{0x10010f1, 611},
{0x10010f2, 612},
{0x10010f3, 633},
{0x10010f4, 610},
{0x10010f5, 613},
{0x10010f6, 606},
{0x1001e02, 277},
{0x1001e03, 1681},
{0x1001e0a, 450},
{0x1001e0b, 2001},
{0x1001e1e, 547},
{0x1001e1f, 2120},
{0x1001e36, 991},
{0x1001e37, 2325},
{0x1001e40, 1007},
{0x1001e41, 2351},
{0x1001e56, 1175},
{0x1001e57, 2469},
{0x1001e60, 1272},
{0x1001e61, 2511},
{0x1001e6a, 1455},
{0x1001e6b, 2539},
{0x1001e80, 1619},
{0x1001e81, 2609},
{0x1001e82, 1614},
{0x1001e83, 2606},
{0x1001e84, 1617},
{0x1001e85, 2608},
{0x1001e8a, 1625},
{0x1001e8b, 2611},
{0x1001ea0, 47},
{0x1001ea1, 1649},
{0x1001ea2, 67},
{0x1001ea3, 1667},
{0x1001ea4, 58},
{0x1001ea5, 1658},
{0x1001ea6, 60},
{0x1001ea7, 1660},
{0x1001ea8, 61},
{0x1001ea9, 1661},
{0x1001eaa, 62},
{0x1001eab, 1662},
{0x1001eac, 59},
{0x1001ead, 1659},
{0x1001eae, 49},
{0x1001eaf, 1652},
{0x1001eb0, 51},
{0x1001eb1, 1654},
{0x1001eb2, 52},
{0x1001eb3, 1655},
{0x1001eb4, 53},
{0x1001eb5, 1656},
{0x1001eb6, 50},
{0x1001eb7, 1653},
{0x1001eb8, 480},
{0x1001eb9, 2080},
{0x1001eba, 492},
{0x1001ebb, 2090},
{0x1001ebc, 502},
{0x1001ebd, 2115},
{0x1001ebe, 483},
{0x1001ebf, 2083},
{0x1001ec0, 485},
{0x1001ec1, 2085},
{0x1001ec2, 486},
{0x1001ec3, 2086},
{0x1001ec4, 487},
{0x1001ec5, 2087},
{0x1001ec6, 484},
{0x1001ec7, 2084},
{0x1001ec8, 889},
{0x1001ec9, 2239},
{0x1001eca, 884},
{0x1001ecb, 2231},
{0x1001ecc, 1145},
{0x1001ecd, 2388},
{0x1001ece, 1157},
{0x1001ecf, 2401},
{0x1001ed0, 1148},
{0x1001ed1, 2391},
{0x1001ed2, 1150},
{0x1001ed3, 2393},
{0x1001ed4, 1151},
{0x1001ed5, 2394},
{0x1001ed6, 1152},
{0x1001ed7, 2395},
{0x1001ed8, 1149},
{0x1001ed9, 2392},
{0x1001eda, 1159},
{0x1001edb, 2403},
{0x1001edc, 1161},
{0x1001edd, 2405},
{0x1001ede, 1162},
{0x1001edf, 2406},
{0x1001ee0, 1163},
{0x1001ee1, 2407},
{0x1001ee2, 1160},
{0x1001ee3, 2404},
{0x1001ee4, 1560},
{0x1001ee5, 2572},
{0x1001ee6, 1566},
{0x1001ee7, 2578},
{0x1001ee8, 1568},
{0x1001ee9, 2580},
{0x1001eea, 1570},
{0x1001eeb, 2582},
{0x1001eec, 1571},
{0x1001eed, 2583},
{0x1001eee, 1572},
{0x1001eef, 2584},
{0x1001ef0, 1569},
{0x1001ef1, 2581},
{0x1001ef2, 1633},
{0x1001ef3, 2618},
{0x1001ef4, 1629},
{0x1001ef5, 2614},
{0x1001ef6, 1634},
{0x1001ef7, 2619},
{0x1001ef8, 1635},
{0x1001ef9, 2620},
{0x1002070, 2626},
{0x1002074, 2135},
{0x1002075, 2132},
{0x1002076, 2530},
{0x1002077, 2524},
{0x1002078, 2092},
{0x1002079, 2374},
{0x1002080, 2625},
{0x1002081, 2414},
{0x1002082, 2567},
{0x1002083, 2550},
{0x1002084, 2134},
{0x1002085, 2131},
{0x1002086, 2529},
{0x1002087, 2523},
{0x1002088, 2091},
{0x1002089, 2373},
{0x10020a0, 488},
{0x10020a1, 330},
{0x10020a2, 339},
{0x10020a3, 546},
{0x10020a4, 1001},
{0x10020a5, 1087},
{0x10020a6, 1104},
{0x10020a7, 1182},
{0x10020a8, 1269},
{0x10020a9, 1622},
{0x10020aa, 1110},
{0x10020ab, 468},
{0x1002202, 2473},
{0x1002205, 2103},
{0x1002208, 2093},
{0x1002209, 2378},
{0x100220b, 1993},
{0x100221a, 2534},
{0x100221b, 1997},
{0x100221c, 2136},
{0x100222c, 2064},
{0x100222d, 2552},
{0x1002235, 1685},
{0x1002247, 2377},
{0x1002248, 1672},
{0x1002262, 2380},
{0x1002263, 2537},
{0x1002800, 1701},
{0x1002801, 1712},
{0x1002802, 1840},
{0x1002803, 1713},
{0x1002804, 1904},
{0x1002805, 1777},
{0x1002806, 1841},
{0x1002807, 1714},
{0x1002808, 1936},
{0x1002809, 1809},
{0x100280a, 1873},
{0x100280b, 1746},
{0x100280c, 1905},
{0x100280d, 1778},
{0x100280e, 1842},
{0x100280f, 1715},
{0x1002810, 1952},
{0x1002811, 1825},
{0x1002812, 1889},
{0x1002813, 1762},
{0x1002814, 1921},
{0x1002815, 1794},
{0x1002816, 1858},
{0x1002817, 1731},
{0x1002818, 1937},
{0x1002819, 1810},
{0x100281a, 1874},
{0x100281b, 1747},
{0x100281c, 1906},
{0x100281d, 1779},
{0x100281e, 1843},
{0x100281f, 1716},
{0x1002820, 1960},
{0x1002821, 1833},
{0x1002822, 1897},
{0x1002823, 1770},
{0x1002824, 1929},
{0x1002825, 1802},
{0x1002826, 1866},
{0x1002827, 1739},
{0x1002828, 1945},
{0x1002829, 1818},
{0x100282a, 1882},
{0x100282b, 1755},
{0x100282c, 1914},
{0x100282d, 1787},
{0x100282e, 1851},
{0x100282f, 1724},
{0x1002830, 1953},
{0x1002831, 1826},
{0x1002832, 1890},
{0x1002833, 1763},
{0x1002834, 1922},
{0x1002835, 1795},
{0x1002836, 1859},
{0x1002837, 1732},
{0x1002838, 1938},
{0x1002839, 1811},
{0x100283a, 1875},
{0x100283b, 1748},
{0x100283c, 1907},
{0x100283d, 1780},
{0x100283e, 1844},
{0x100283f, 1717},
{0x1002840, 1964},
{0x1002841, 1837},
{0x1002842, 1901},
{0x1002843, 1774},
{0x1002844, 1933},
{0x1002845, 1806},
{0x1002846, 1870},
{0x1002847, 1743},
{0x1002848, 1949},
{0x1002849, 1822},
{0x100284a, 1886},
{0x100284b, 1759},
{0x100284c, 1918},
{0x100284d, 1791},
{0x100284e, 1855},
{0x100284f, 1728},
{0x1002850, 1957},
{0x1002851, 1830},
{0x1002852, 1894},
{0x1002853, 1767},
{0x1002854, 1926},
{0x1002855, 1799},
{0x1002856, 1863},
{0x1002857, 1736},
{0x1002858, 1942},
{0x1002859, 1815},
{0x100285a, 1879},
{0x100285b, 1752},
{0x100285c, 1911},
{0x100285d, 1784},
{0x100285e, 1848},
{0x100285f, 1721},
{0x1002860, 1961},
{0x1002861, 1834},
{0x1002862, 1898},
{0x1002863, 1771},
{0x1002864, 1930},
{0x1002865, 1803},
{0x1002866, 1867},
{0x1002867, 1740},
{0x1002868, 1946},
{0x1002869, 1819},
{0x100286a, 1883},
{0x100286b, 1756},
{0x100286c, 1915},
{0x100286d, 1788},
{0x100286e, 1852},
{0x100286f, 1725},
{0x1002870, 1954},
{0x1002871, 1827},
{0x1002872, 1891},
{0x1002873, 1764},
{0x1002874, 1923},
{0x1002875, 1796},
{0x1002876, 1860},
{0x1002877, 1733},
{0x1002878, 1939},
{0x1002879, 1812},
{0x100287a, 1876},
{0x100287b, 1749},
{0x100287c, 1908},
{0x100287d, 1781},
{0x100287e, 1845},
{0x100287f, 1718},
{0x1002880, 1966},
{0x1002881, 1839},
{0x1002882, 1903},
{0x1002883, 1776},
{0x1002884, 1935},
{0x1002885, 1808},
{0x1002886, 1872},
{0x1002887, 1745},
{0x1002888, 1951},
{0x1002889, 1824},
{0x100288a, 1888},
{0x100288b, 1761},
{0x100288c, 1920},
{0x100288d, 1793},
{0x100288e, 1857},
{0x100288f, 1730},
{0x1002890, 1959},
{0x1002891, 1832},
{0x1002892, 1896},
{0x1002893, 1769},
{0x1002894, 1928},
{0x1002895, 1801},
{0x1002896, 1865},
{0x1002897, 1738},
{0x1002898, 1944},
{0x1002899, 1817},
{0x100289a, 1881},
{0x100289b, 1754},
{0x100289c, 1913},
{0x100289d, 1786},
{0x100289e, 1850},
{0x100289f, 1723},
{0x10028a0, 1963},
{0x10028a1, 1836},
{0x10028a2, 1900},
{0x10028a3, 1773},
{0x10028a4, 1932},
{0x10028a5, 1805},
{0x10028a6, 1869},
{0x10028a7, 1742},
{0x10028a8, 1948},
{0x10028a9, 1821},
{0x10028aa, 1885},
{0x10028ab, 1758},
{0x10028ac, 1917},
{0x10028ad, 1790},
{0x10028ae, 1854},
{0x10028af, 1727},
{0x10028b0, 1956},
{0x10028b1, 1829},
{0x10028b2, 1893},
{0x10028b3, 1766},
{0x10028b4, 1925},
{0x10028b5, 1798},
{0x10028b6, 1862},
{0x10028b7, 1735},
{0x10028b8, 1941},
{0x10028b9, 1814},
{0x10028ba, 1878},
{0x10028bb, 1751},
{0x10028bc, 1910},
{0x10028bd, 1783},
{0x10028be, 1847},
{0x10028bf, 1720},
{0x10028c0, 1965},
{0x10028c1, 1838},
{0x10028c2, 1902},
{0x10028c3, 1775},
{0x10028c4, 1934},
{0x10028c5, 1807},
{0x10028c6, 1871},
{0x10028c7, 1744},
{0x10028c8, 1950},
{0x10028c9, 1823},
{0x10028ca, 1887},
{0x10028cb, 1760},
{0x10028cc, 1919},
{0x10028cd, 1792},
{0x10028ce, 1856},
{0x10028cf, 1729},
{0x10028d0, 1958},
{0x10028d1, 1831},
{0x10028d2, 1895},
{0x10028d3, 1768},
{0x10028d4, 1927},
{0x10028d5, 1800},
{0x10028d6, 1864},
{0x10028d7, 1737},
{0x10028d8, 1943},
{0x10028d9, 1816},
{0x10028da, 1880},
{0x10028db, 1753},
{0x10028dc, 1912},
{0x10028dd, 1785},
{0x10028de, 1849},
{0x10028df, 1722},
{0x10028e0, 1962},
{0x10028e1, 1835},
{0x10028e2, 1899},
{0x10028e3, 1772},
{0x10028e4, 1931},
{0x10028e5, 1804},
{0x10028e6, 1868},
{0x10028e7, 1741},
{0x10028e8, 1947},
{0x10028e9, 1820},
{0x10028ea, 1884},
{0x10028eb, 1757},
{0x10028ec, 1916},
{0x10028ed, 1789},
{0x10028ee, 1853},
{0x10028ef, 1726},
{0x10028f0, 1955},
{0x10028f1, 1828},
{0x10028f2, 1892},
{0x10028f3, 1765},
{0x10028f4, 1924},
{0x10028f5, 1797},
{0x10028f6, 1861},
{0x10028f7, 1734},
{0x10028f8, 1940},
{0x10028f9, 1813},
{0x10028fa, 1877},
{0x10028fb, 1750},
{0x10028fc, 1909},
{0x10028fd, 1782},
{0x10028fe, 1846},
{0x10028ff, 1719},
{0x100000a8, 2220},
{0x100000a9, 2224},
{0x100000aa, 2221},
{0x100000ab, 2223},
{0x100000ac, 2222},
{0x100000af, 2218},
{0x100000be, 2147},
{0x100000ee, 841},
{0x100000f6, 2219},
{0x100000fc, 1687},
{0x1000fe22, 457},
{0x1000fe27, 451},
{0x1000fe2c, 455},
{0x1000fe5e, 456},
{0x1000fe60, 461},
{0x1000fe7e, 472},
{0x1000feb0, 470},
{0x1000ff00, 448},
{0x1000ff48, 2210},
{0x1000ff49, 2211},
{0x1000ff6c, 1255},
{0x1000ff6d, 1451},
{0x1000ff6e, 1594},
{0x1000ff6f, 326},
{0x1000ff70, 895},
{0x1000ff71, 460},
{0x1000ff72, 894},
{0x1000ff73, 459},
{0x1000ff74, 281},
{0x1000ff75, 913},
{0x1000ff76, 508},
{0x1000ff77, 509},
{0x1004ff02, 2432},
{0x1004ff03, 2433},
{0x1004ff04, 2452},
{0x1004ff07, 2427},
{0x1004ff08, 2426},
{0x1004ff0b, 2431},
{0x1004ff1b, 2439},
{0x1004ff31, 2425},
{0x1004ff32, 2455},
{0x1004ff33, 2456},
{0x1004ff40, 2449},
{0x1004ff41, 2451},
{0x1004ff42, 2448},
{0x1004ff43, 2450},
{0x1004ff44, 2424},
{0x1004ff45, 2445},
{0x1004ff51, 2443},
{0x1004ff52, 2463},
{0x1004ff53, 2459},
{0x1004ff54, 2436},
{0x1004ff57, 2438},
{0x1004ff58, 2429},
{0x1004ff59, 2437},
{0x1004ff5a, 2428},
{0x1004ff5b, 2454},
{0x1004ff5c, 2447},
{0x1004ff5d, 2453},
{0x1004ff5e, 2446},
{0x1004ff60, 2460},
{0x1004ff63, 2442},
{0x1004ff65, 2462},
{0x1004ff67, 2444},
{0x1004ff69, 2430},
{0x1004ff6a, 2441},
{0x1004ff71, 2461},
{0x1004ff72, 2435},
{0x1004ff73, 2457},
{0x1004ff74, 2440},
{0x1004ff78, 2458},
{0x1004ffff, 2434},
{0x1005ff00, 1416},
{0x1005ff01, 1414},
{0x1005ff02, 1417},
{0x1005ff03, 1412},
{0x1005ff04, 1415},
{0x1005ff05, 1413},
{0x1005ff10, 1410},
{0x1005ff11, 1411},
{0x1005ff60, 1429},
{0x1005ff70, 1427},
{0x1005ff71, 1419},
{0x1005ff72, 1408},
{0x1005ff73, 1420},
{0x1005ff74, 1423},
{0x1005ff75, 1409},
{0x1005ff76, 1424},
{0x1005ff77, 1404},
{0x1005ff78, 1405},
{0x1005ff79, 1406},
{0x1005ff7a, 1431},
{0x1005ff7b, 1432},
{0x1005ff7c, 1433},
{0x1005ff7d, 1425},
{0x100810a4, 1058},
{0x100810ae, 506},
{0x100810d1, 254},
{0x100810dc, 1395},
{0x100810f4, 290},
{0x100810f5, 464},
{0x10081160, 1142},
{0x10081162, 638},
{0x10081166, 892},
{0x10081168, 1602},
{0x1008116a, 1068},
{0x1008116e, 1066},
{0x10081170, 1057},
{0x10081171, 1077},
{0x10081175, 255},
{0x10081177, 246},
{0x10081178, 1067},
{0x10081179, 1071},
{0x1008117a, 1064},
{0x1008117b, 1075},
{0x1008117c, 1076},
{0x1008117d, 1070},
{0x10081180, 1072},
{0x10081181, 1069},
{0x10081182, 1074},
{0x10081183, 1060},
{0x10081184, 1073},
{0x10081185, 449},
{0x10081186, 1062},
{0x10081188, 253},
{0x10081192, 323},
{0x10081193, 322},
{0x10081199, 1059},
{0x1008119b, 1056},
{0x1008119d, 1121},
{0x100811a0, 1604},
{0x100811a4, 1645},
{0x100811a6, 490},
{0x100811a8, 639},
{0x100811a9, 1218},
{0x100811aa, 453},
{0x100811ac, 1607},
{0x100811ad, 64},
{0x100811af, 465},
{0x100811b0, 1393},
{0x100811b6, 333},
{0x100811b7, 1061},
{0x100811b8, 3},
{0x100811b9, 2},
{0x100811ba, 891},
{0x100811bc, 1118},
{0x100811bd, 1184},
{0x100811be, 823},
{0x100811bf, 1000},
{0x100811d0, 565},
{0x100811d1, 572},
{0x100811d2, 574},
{0x100811d3, 578},
{0x100811d4, 579},
{0x100811d5, 580},
{0x100811d6, 581},
{0x100811d7, 582},
{0x100811d8, 583},
{0x100811d9, 584},
{0x100811da, 585},
{0x100811db, 575},
{0x100811dc, 576},
{0x100811dd, 577},
{0x100811de, 567},
{0x100811df, 568},
{0x100811e0, 570},
{0x100811e1, 571},
{0x100811e2, 573},
{0x100811e3, 586},
{0x100811e4, 569},
{0x100811e5, 566},
{0x10081200, 1122},
{0x10081201, 1123},
{0x10081202, 1126},
{0x10081203, 1127},
{0x10081204, 1128},
{0x10081205, 1129},
{0x10081206, 1130},
{0x10081207, 1131},
{0x10081208, 1132},
{0x10081209, 1133},
{0x1008120a, 1139},
{0x1008120b, 1138},
{0x1008120c, 1134},
{0x1008120d, 1135},
{0x1008120e, 1136},
{0x1008120f, 1137},
{0x10081210, 310},
{0x10081211, 1611},
{0x10081215, 314},
{0x10081216, 315},
{0x10081217, 313},
{0x10081218, 309},
{0x10081219, 311},
{0x1008121a, 312},
{0x1008121b, 250},
{0x1008121c, 249},
{0x1008121d, 251},
{0x1008121e, 998},
{0x10081230, 45},
{0x10081232, 1251},
{0x10081240, 293},
{0x10081241, 1457},
{0x10081242, 900},
{0x10081243, 335},
{0x10081244, 72},
{0x10081245, 1279},
{0x10081246, 1606},
{0x10081247, 247},
{0x10081249, 497},
{0x1008124a, 462},
{0x1008124b, 307},
{0x1008124c, 306},
{0x1008124d, 308},
{0x1008124e, 56},
{0x1008124f, 466},
{0x10081250, 292},
{0x10081251, 291},
{0x10081260, 951},
{0x10081261, 949},
{0x10081262, 952},
{0x10081263, 950},
{0x10081264, 947},
{0x10081265, 948},
{0x10081266, 1259},
{0x10081267, 1258},
{0x10081268, 996},
{0x10081269, 995},
{0x1008126a, 1264},
{0x1008126b, 1078},
{0x1008126c, 1124},
{0x1008126d, 1125},
{0x1008126e, 257},
{0x1008126f, 36},
{0x10081270, 1114},
{0x10081271, 1400},
{0x10081272, 1180},
{0x10081273, 1600},
{0x10081274, 1590},
{0x10081275, 559},
{0x10081276, 1390},
{0x10081277, 452},
{0x10081278, 1165},
{0x10081279, 1225},
{0x1008127a, 1287},
{0x1008127b, 1113},
{0x1008127c, 1222},
{0x1008127d, 274},
{0x1008127e, 1053},
{0x1008127f, 1391},
{0x10081280, 1105},
{0x10081281, 564},
{0x10081282, 1307},
{0x10081283, 473},
{0x10081284, 1245},
{0x10081285, 1555},
{0x10081286, 327},
{0x10081287, 1305},
{0x10081288, 1106},
{0x10081290, 1014},
{0x10081291, 1025},
{0x10081292, 1036},
{0x10081293, 1038},
{0x10081294, 1039},
{0x10081295, 1040},
{0x10081296, 1041},
{0x10081297, 1042},
{0x10081298, 1043},
{0x10081299, 1015},
{0x1008129a, 1016},
{0x1008129b, 1017},
{0x1008129c, 1018},
{0x1008129d, 1019},
{0x1008129e, 1020},
{0x1008129f, 1021},
{0x100812a0, 1022},
{0x100812a1, 1023},
{0x100812a2, 1024},
{0x100812a3, 1026},
{0x100812a4, 1027},
{0x100812a5, 1028},
{0x100812a6, 1029},
{0x100812a7, 1030},
{0x100812a8, 1031},
{0x100812a9, 1032},
{0x100812aa, 1033},
{0x100812ab, 1034},
{0x100812ac, 1035},
{0x100812ad, 1037},
{0x100812b0, 1048},
{0x100812b1, 1049},
{0x100812b2, 1047},
{0x100812b3, 1044},
{0x100812b4, 1045},
{0x100812b5, 1046},
{0x100812b8, 953},
{0x100812b9, 954},
{0x100812ba, 955},
{0x100812bb, 956},
{0x100812bc, 957},
{0x100812bd, 1181},
{0x1008fe01, 1438},
{0x1008fe02, 1442},
{0x1008fe03, 1443},
{0x1008fe04, 1444},
{0x1008fe05, 1445},
{0x1008fe06, 1446},
{0x1008fe07, 1447},
{0x1008fe08, 1448},
{0x1008fe09, 1449},
{0x1008fe0a, 1439},
{0x1008fe0b, 1440},
{0x1008fe0c, 1441},
{0x1008fe20, 1589},
{0x1008fe21, 325},
{0x1008fe22, 1115},
{0x1008fe23, 1219},
{0x1008fe24, 1004},
{0x1008fe25, 1002},
{0x1008ff01, 1088},
{0x1008ff02, 1093},
{0x1008ff03, 1092},
{0x1008ff04, 958},
{0x1008ff05, 946},
{0x1008ff06, 945},
{0x1008ff07, 1091},
{0x1008ff10, 1396},
{0x1008ff11, 259},
{0x1008ff12, 262},
{0x1008ff13, 268},
{0x1008ff14, 265},
{0x1008ff15, 273},
{0x1008ff16, 267},
{0x1008ff17, 263},
{0x1008ff18, 835},
{0x1008ff19, 1051},
{0x1008ff1a, 1397},
{0x1008ff1b, 1284},
{0x1008ff1c, 270},
{0x1008ff1d, 304},
{0x1008ff1e, 1080},
{0x1008ff1f, 1548},
{0x1008ff20, 305},
{0x1008ff21, 1216},
{0x1008ff22, 334},
{0x1008ff23, 1262},
{0x1008ff24, 1260},
{0x1008ff25, 1261},
{0x1008ff26, 278},
{0x1008ff27, 587},
{0x1008ff28, 1399},
{0x1008ff29, 1250},
{0x1008ff2a, 1217},
{0x1008ff2b, 1615},
{0x1008ff2c, 495},
{0x1008ff2d, 1278},
{0x1008ff2e, 1613},
{0x1008ff2f, 1388},
{0x1008ff30, 560},
{0x1008ff31, 264},
{0x1008ff32, 260},
{0x1008ff33, 1100},
{0x1008ff34, 1601},
{0x1008ff35, 997},
{0x1008ff36, 1304},
{0x1008ff37, 833},
{0x1008ff38, 1168},
{0x1008ff39, 63},
{0x1008ff3a, 836},
{0x1008ff3b, 289},
{0x1008ff3c, 561},
{0x1008ff3d, 331},
{0x1008ff3e, 272},
{0x1008ff3f, 279},
{0x1008ff40, 975},
{0x1008ff41, 976},
{0x1008ff42, 977},
{0x1008ff43, 978},
{0x1008ff44, 979},
{0x1008ff45, 980},
{0x1008ff46, 981},
{0x1008ff47, 982},
{0x1008ff48, 983},
{0x1008ff49, 984},
{0x1008ff4a, 985},
{0x1008ff4b, 986},
{0x1008ff4c, 987},
{0x1008ff4d, 988},
{0x1008ff4e, 989},
{0x1008ff4f, 990},
{0x1008ff50, 73},
{0x1008ff51, 74},
{0x1008ff52, 286},
{0x1008ff53, 297},
{0x1008ff54, 303},
{0x1008ff55, 1621},
{0x1008ff56, 328},
{0x1008ff57, 338},
{0x1008ff58, 340},
{0x1008ff59, 463},
{0x1008ff5a, 447},
{0x1008ff5b, 467},
{0x1008ff5c, 504},
{0x1008ff5d, 507},
{0x1008ff5e, 593},
{0x1008ff5f, 637},
{0x1008ff60, 2229},
{0x1008ff61, 1003},
{0x1008ff62, 1054},
{0x1008ff63, 1079},
{0x1008ff65, 1082},
{0x1008ff66, 1083},
{0x1008ff67, 1101},
{0x1008ff68, 1109},
{0x1008ff69, 1111},
{0x1008ff6a, 1155},
{0x1008ff6b, 1167},
{0x1008ff6c, 1169},
{0x1008ff6d, 1178},
{0x1008ff6e, 1183},
{0x1008ff70, 332},
{0x1008ff72, 1254},
{0x1008ff73, 1252},
{0x1008ff74, 1265},
{0x1008ff75, 1268},
{0x1008ff76, 1266},
{0x1008ff77, 1274},
{0x1008ff78, 1282},
{0x1008ff79, 1281},
{0x1008ff7a, 1280},
{0x1008ff7b, 1288},
{0x1008ff7c, 1392},
{0x1008ff7d, 1394},
{0x1008ff7e, 1436},
{0x1008ff7f, 1456},
{0x1008ff80, 1460},
{0x1008ff81, 1549},
{0x1008ff82, 1556},
{0x1008ff84, 1597},
{0x1008ff85, 1595},
{0x1008ff86, 1596},
{0x1008ff87, 1603},
{0x1008ff88, 1620},
{0x1008ff89, 1623},
{0x1008ff8a, 1626},
{0x1008ff8b, 1643},
{0x1008ff8c, 1644},
{0x1008ff8d, 275},
{0x1008ff8e, 1084},
{0x1008ff8f, 1618},
{0x1008ff90, 1052},
{0x1008ff91, 1185},
{0x1008ff92, 1099},
{0x1008ff93, 282},
{0x1008ff94, 285},
{0x1008ff95, 1610},
{0x1008ff97, 258},
{0x1008ff98, 271},
{0x1008ff99, 269},
{0x1008ff9a, 1401},
{0x1008ff9b, 256},
{0x1008ff9c, 341},
{0x1008ff9d, 588},
{0x1008ff9e, 589},
{0x1008ff9f, 1547},
{0x1008ffa0, 1286},
{0x1008ffa1, 1605},
{0x1008ffa2, 1550},
{0x1008ffa3, 1248},
{0x1008ffa4, 715},
{0x1008ffa5, 1632},
{0x1008ffa6, 284},
{0x1008ffa7, 1437},
{0x1008ffa8, 830},
{0x1008ffa9, 1553},
{0x1008ffb0, 1552},
{0x1008ffb1, 1551},
{0x1008ffb2, 261},
{0x1008ffb3, 960},
{0x1008ffb4, 1612},
{0x1008ffb5, 1243},
{0x1008ffb6, 266},
{0x1008ffb7, 1267},
{0x1008ffb8, 590},
};

FCITX_C_DECL_END


#endif