// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v3.21.12
// source: workload_identity.proto

package mwlid

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.62.0 or later.
const _ = grpc.SupportPackageIsVersion8

const (
	WorkloadIdentity_GetWorkloadTrustBundles_FullMethodName = "/managed_workload_identity.proto.v1.WorkloadIdentity/GetWorkloadTrustBundles"
	WorkloadIdentity_GetWorkloadCertificates_FullMethodName = "/managed_workload_identity.proto.v1.WorkloadIdentity/GetWorkloadCertificates"
)

// WorkloadIdentityClient is the client API for WorkloadIdentity service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WorkloadIdentityClient interface {
	// Returns the SPIFFE trust bundles map containing trust domains and their
	// corresponding cryptographic keys used for validating X.509-SVID(s).
	GetWorkloadTrustBundles(ctx context.Context, in *GetWorkloadTrustBundlesRequest, opts ...grpc.CallOption) (*GetWorkloadTrustBundlesResponse, error)
	// Returns the certificate chain containing the X.509-SVID for the SPIFFE
	// identity assigned to the workload that the client can use for TLS
	// handshake.
	GetWorkloadCertificates(ctx context.Context, in *GetWorkloadCertificatesRequest, opts ...grpc.CallOption) (*GetWorkloadCertificatesResponse, error)
}

type workloadIdentityClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkloadIdentityClient(cc grpc.ClientConnInterface) WorkloadIdentityClient {
	return &workloadIdentityClient{cc}
}

func (c *workloadIdentityClient) GetWorkloadTrustBundles(ctx context.Context, in *GetWorkloadTrustBundlesRequest, opts ...grpc.CallOption) (*GetWorkloadTrustBundlesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetWorkloadTrustBundlesResponse)
	err := c.cc.Invoke(ctx, WorkloadIdentity_GetWorkloadTrustBundles_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityClient) GetWorkloadCertificates(ctx context.Context, in *GetWorkloadCertificatesRequest, opts ...grpc.CallOption) (*GetWorkloadCertificatesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetWorkloadCertificatesResponse)
	err := c.cc.Invoke(ctx, WorkloadIdentity_GetWorkloadCertificates_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkloadIdentityServer is the server API for WorkloadIdentity service.
// All implementations must embed UnimplementedWorkloadIdentityServer
// for forward compatibility
type WorkloadIdentityServer interface {
	// Returns the SPIFFE trust bundles map containing trust domains and their
	// corresponding cryptographic keys used for validating X.509-SVID(s).
	GetWorkloadTrustBundles(context.Context, *GetWorkloadTrustBundlesRequest) (*GetWorkloadTrustBundlesResponse, error)
	// Returns the certificate chain containing the X.509-SVID for the SPIFFE
	// identity assigned to the workload that the client can use for TLS
	// handshake.
	GetWorkloadCertificates(context.Context, *GetWorkloadCertificatesRequest) (*GetWorkloadCertificatesResponse, error)
	mustEmbedUnimplementedWorkloadIdentityServer()
}

// UnimplementedWorkloadIdentityServer must be embedded to have forward compatible implementations.
type UnimplementedWorkloadIdentityServer struct {
}

func (UnimplementedWorkloadIdentityServer) GetWorkloadTrustBundles(context.Context, *GetWorkloadTrustBundlesRequest) (*GetWorkloadTrustBundlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkloadTrustBundles not implemented")
}
func (UnimplementedWorkloadIdentityServer) GetWorkloadCertificates(context.Context, *GetWorkloadCertificatesRequest) (*GetWorkloadCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkloadCertificates not implemented")
}
func (UnimplementedWorkloadIdentityServer) mustEmbedUnimplementedWorkloadIdentityServer() {}

// UnsafeWorkloadIdentityServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WorkloadIdentityServer will
// result in compilation errors.
type UnsafeWorkloadIdentityServer interface {
	mustEmbedUnimplementedWorkloadIdentityServer()
}

func RegisterWorkloadIdentityServer(s grpc.ServiceRegistrar, srv WorkloadIdentityServer) {
	s.RegisterService(&WorkloadIdentity_ServiceDesc, srv)
}

func _WorkloadIdentity_GetWorkloadTrustBundles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadTrustBundlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityServer).GetWorkloadTrustBundles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkloadIdentity_GetWorkloadTrustBundles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityServer).GetWorkloadTrustBundles(ctx, req.(*GetWorkloadTrustBundlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentity_GetWorkloadCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityServer).GetWorkloadCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkloadIdentity_GetWorkloadCertificates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityServer).GetWorkloadCertificates(ctx, req.(*GetWorkloadCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WorkloadIdentity_ServiceDesc is the grpc.ServiceDesc for WorkloadIdentity service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WorkloadIdentity_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "managed_workload_identity.proto.v1.WorkloadIdentity",
	HandlerType: (*WorkloadIdentityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetWorkloadTrustBundles",
			Handler:    _WorkloadIdentity_GetWorkloadTrustBundles_Handler,
		},
		{
			MethodName: "GetWorkloadCertificates",
			Handler:    _WorkloadIdentity_GetWorkloadCertificates_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "workload_identity.proto",
}
